/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.jei;

import ipsis.woot.crafting.anvil.AnvilRecipe;
import ipsis.woot.modules.anvil.AnvilSetup;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class AnvilRecipeCategory
implements IRecipeCategory<AnvilRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"woot", (String)"gem_infusing");
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"woot", (String)"textures/gui/jei/anvil.png");
    public static final RecipeType<AnvilRecipe> ANVIL_TYPE = new RecipeType(UID, AnvilRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;

    public AnvilRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 176, 85);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)AnvilSetup.ANVIL_BLOCK.get()));
    }

    public RecipeType<AnvilRecipe> getRecipeType() {
        return ANVIL_TYPE;
    }

    public Component getTitle() {
        return Component.literal((String)"Stygian Anvil");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, AnvilRecipe recipe, IFocusGroup focuses) {
        List<Ingredient> ing = recipe.ingredients();
        builder.addSlot(RecipeIngredientRole.INPUT, 82, 40).addIngredients(recipe.baseItem());
        int x = 28;
        int y = 29;
        builder.addSlot(RecipeIngredientRole.INPUT, x, y).addIngredients(ing.get(0));
        if (ing.size() > 1) {
            builder.addSlot(RecipeIngredientRole.INPUT, x + 18, y).addIngredients(ing.get(1));
        }
        if (ing.size() > 2) {
            builder.addSlot(RecipeIngredientRole.INPUT, x, y + 18).addIngredients(ing.get(2));
        }
        if (ing.size() > 3) {
            builder.addSlot(RecipeIngredientRole.INPUT, x + 18, y + 18).addIngredients(ing.get(3));
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 118, 40).addItemStack(recipe.output());
    }
}

