/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.jei;

import ipsis.woot.crafting.dyesqueezer.DyeSqueezerRecipe;
import ipsis.woot.jei.RenderHelper;
import ipsis.woot.modules.squeezer.SqueezerConfiguration;
import ipsis.woot.modules.squeezer.SqueezerSetup;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class DyeSqueezerRecipeCategory
implements IRecipeCategory<DyeSqueezerRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"woot", (String)"dyesqueezing");
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"woot", (String)"textures/gui/jei/squeezer.png");
    public static final RecipeType<DyeSqueezerRecipe> SQUEEZER_TYPE = new RecipeType(UID, DyeSqueezerRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;

    public DyeSqueezerRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 176, 85);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)SqueezerSetup.SQUEEZER_BLOCK.get()));
    }

    public RecipeType<DyeSqueezerRecipe> getRecipeType() {
        return SQUEEZER_TYPE;
    }

    public Component getTitle() {
        return Component.literal((String)"Infuser");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, DyeSqueezerRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 50, 40).addIngredients(recipe.input());
    }

    public void draw(DyeSqueezerRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        RenderHelper.renderEnergyBar(guiGraphics, 10, 77, 60, 16, recipe.energy(), (Integer)SqueezerConfiguration.DYE_SQUEEZER_MAX_ENERGY.get());
        if (mouseX > 10.0 && mouseX < 26.0 && mouseY < 77.0 && mouseY > 18.0) {
            guiGraphics.renderTooltip(Minecraft.getInstance().font, (Component)Component.literal((String)(recipe.energy() + " RF")), (int)mouseX, (int)mouseY);
        }
    }
}

