/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.jei;

import ipsis.woot.crafting.enchantsqueezer.EnchantSqueezerRecipe;
import ipsis.woot.jei.RenderHelper;
import ipsis.woot.modules.squeezer.SqueezerConfiguration;
import ipsis.woot.modules.squeezer.SqueezerSetup;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class EnchantSqueezerRecipeCategory
implements IRecipeCategory<EnchantSqueezerRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"woot", (String)"enchantsqueezing");
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"woot", (String)"textures/gui/jei/enchsqueezer.png");
    public static final RecipeType<EnchantSqueezerRecipe> ENCHANT_TYPE = new RecipeType(UID, EnchantSqueezerRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;

    public EnchantSqueezerRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 176, 85);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)SqueezerSetup.ENCHANT_SQUEEZER_BLOCK.get()));
    }

    public RecipeType<EnchantSqueezerRecipe> getRecipeType() {
        return ENCHANT_TYPE;
    }

    public Component getTitle() {
        return Component.literal((String)"Infuser");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, EnchantSqueezerRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 50, 40).addIngredients(recipe.itemStack());
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 154, 18).addFluidStack(recipe.getOutput().getFluid(), (long)recipe.getOutput().getAmount())).setFluidRenderer(10000L, true, 16, 60);
    }

    public void draw(EnchantSqueezerRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        RenderHelper.renderEnergyBar(guiGraphics, 10, 77, 60, 16, recipe.getEnergy(), (Integer)SqueezerConfiguration.ENCH_SQUEEZER_MAX_ENERGY.get());
        if (mouseX > 10.0 && mouseX < 26.0 && mouseY < 77.0 && mouseY > 18.0) {
            guiGraphics.renderTooltip(Minecraft.getInstance().font, (Component)Component.literal((String)(recipe.getEnergy() + " RF")), (int)mouseX, (int)mouseY);
        }
    }
}

