/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.jei;

import ipsis.woot.crafting.fluidconvertor.FluidConvertorRecipe;
import ipsis.woot.jei.RenderHelper;
import ipsis.woot.modules.fluidconvertor.FluidConvertorConfiguration;
import ipsis.woot.modules.fluidconvertor.FluidConvertorSetup;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class FluidConvertorRecipeCategory
implements IRecipeCategory<FluidConvertorRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"woot", (String)"converting");
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"woot", (String)"textures/gui/jei/fluidconvertor.png");
    public static final RecipeType<FluidConvertorRecipe> FLUID_CONVERTOR_TYPE = new RecipeType(UID, FluidConvertorRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;

    public FluidConvertorRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 176, 85);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)FluidConvertorSetup.FLUID_CONVERTOR_BLOCK.get()));
    }

    public RecipeType<FluidConvertorRecipe> getRecipeType() {
        return FLUID_CONVERTOR_TYPE;
    }

    public Component getTitle() {
        return Component.literal((String)"Infuser");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FluidConvertorRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 99, 21).addIngredients(recipe.catalyst());
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 46, 18).addFluidStack(recipe.inputFluid().getFluid(), (long)recipe.inputFluid().getAmount())).setFluidRenderer(10000L, true, 16, 60);
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 154, 18).addFluidStack(recipe.outputFluid().getFluid(), (long)recipe.outputFluid().getAmount())).setFluidRenderer(10000L, true, 16, 60);
    }

    public void draw(FluidConvertorRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        RenderHelper.renderEnergyBar(guiGraphics, 10, 77, 60, 16, recipe.energy(), (Integer)FluidConvertorConfiguration.FLUID_CONV_MAX_ENERGY.get());
        if (mouseX > 10.0 && mouseX < 26.0 && mouseY < 77.0 && mouseY > 18.0) {
            guiGraphics.renderTooltip(Minecraft.getInstance().font, (Component)Component.literal((String)(recipe.energy() + " RF")), (int)mouseX, (int)mouseY);
        }
    }
}

