/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.jei;

import ipsis.woot.crafting.infuser.InfuserRecipe;
import ipsis.woot.jei.RenderHelper;
import ipsis.woot.modules.infuser.InfuserConfiguration;
import ipsis.woot.modules.infuser.InfuserSetup;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class InfuserRecipeCategory
implements IRecipeCategory<InfuserRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"woot", (String)"infusing");
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"woot", (String)"textures/gui/jei/infuser.png");
    public static final RecipeType<InfuserRecipe> INFUSER_TYPE = new RecipeType(UID, InfuserRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;

    public InfuserRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 176, 85);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)InfuserSetup.INFUSER_BLOCK.get()));
    }

    public RecipeType<InfuserRecipe> getRecipeType() {
        return INFUSER_TYPE;
    }

    public Component getTitle() {
        return Component.literal((String)"Infuser");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, InfuserRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 46, 40).addIngredients(recipe.ingredient());
        builder.addSlot(RecipeIngredientRole.INPUT, 64, 40).addIngredients(recipe.augment());
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 154, 18).addFluidStack(recipe.fluid().getFluid(), (long)recipe.fluid().getAmount())).setFluidRenderer(10000L, true, 16, 60);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 118, 40).addItemStack(recipe.result());
    }

    public void draw(InfuserRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        RenderHelper.renderEnergyBar(guiGraphics, 10, 77, 60, 16, recipe.energy(), (Integer)InfuserConfiguration.INFUSER_MAX_ENERGY.get());
        if (mouseX > 10.0 && mouseX < 26.0 && mouseY < 77.0 && mouseY > 18.0) {
            guiGraphics.renderTooltip(Minecraft.getInstance().font, (Component)Component.literal((String)(recipe.energy() + " RF")), (int)mouseX, (int)mouseY);
        }
    }
}

