/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.jei;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;

public class RenderHelper {
    public static void renderFluidTank(GuiGraphics guiGraphics, int x1, int y1, int height, int width, int max, FluidStack fluidStack) {
        int filled = 0;
        if (max > 0) {
            filled = fluidStack.getAmount() * 100 / max;
        }
        filled = Math.clamp((long)filled, 0, 100);
        int h = filled * height / 100;
        RenderHelper.drawFluid(guiGraphics, x1, y1 - h + 1, fluidStack, width, h);
    }

    public static void drawFluid(GuiGraphics guiGraphics, int x, int y, FluidStack fluidStack, int width, int height) {
        if (fluidStack.getFluid() == Fluids.EMPTY) {
            return;
        }
        Fluid fluid = fluidStack.getFluid();
        IClientFluidTypeExtensions clientFluid = IClientFluidTypeExtensions.of((Fluid)fluid);
        ResourceLocation sprite = clientFluid.getStillTexture(fluidStack);
        ResourceLocation sprite_flowing = clientFluid.getFlowingTexture(fluidStack);
        TextureAtlasSprite fluidTexture = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(sprite);
        int color = clientFluid.getTintColor();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >> 24 & 0xFF) / 255.0f));
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
        RenderHelper.drawTiledTexture(guiGraphics, x, y, fluidTexture, width, height);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void drawTiledTexture(GuiGraphics guiGraphics, int x, int y, TextureAtlasSprite icon, int width, int height) {
        for (int i = 0; i < width; i += 16) {
            for (int j = 0; j < height; j += 16) {
                int drawWidth = Math.min(width - i, 16);
                int drawHeight = Math.min(height - j, 16);
                RenderHelper.drawScaledTexturedModelRectFromIcon(guiGraphics, x + i, y + j, icon, drawWidth, drawHeight);
            }
        }
    }

    public static void drawScaledTexturedModelRectFromIcon(GuiGraphics guiGraphics, int x, int y, TextureAtlasSprite icon, int width, int height) {
        if (icon == null) {
            return;
        }
        float minU = icon.getU0();
        float maxU = icon.getU1();
        float minV = icon.getV0();
        float maxV = icon.getV1();
        float u1 = minU + (maxU - minU) * (float)width / 16.0f;
        float v1 = minV + (maxV - minV) * (float)height / 16.0f;
        guiGraphics.blit(x, y, 0, width, height, icon);
    }

    public static void renderEnergyBar(GuiGraphics guiGraphics, int x1, int y1, int height, int width, int curr, int max) {
        int filled = 0;
        if (max > 0) {
            filled = curr * 100 / max;
        }
        filled = Math.clamp((long)filled, 0, 100);
        int h = filled * height / 100;
        guiGraphics.fill(x1, y1 - h + 1, x1 + width, y1 + 1, -65536);
    }
}

