/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.jei;

import ipsis.woot.crafting.WootRecipes;
import ipsis.woot.jei.AnvilRecipeCategory;
import ipsis.woot.jei.DyeSqueezerRecipeCategory;
import ipsis.woot.jei.EnchantSqueezerRecipeCategory;
import ipsis.woot.jei.FluidConvertorRecipeCategory;
import ipsis.woot.jei.InfuserRecipeCategory;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;

@JeiPlugin
public class WootJEIPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"woot", (String)"jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new AnvilRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new InfuserRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new FluidConvertorRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new DyeSqueezerRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new EnchantSqueezerRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager rm = Objects.requireNonNull(Minecraft.getInstance().level).getRecipeManager();
        registration.addRecipes(AnvilRecipeCategory.ANVIL_TYPE, rm.getAllRecipesFor((RecipeType)WootRecipes.ANVIL_RECIPE_TYPE.get()).stream().map(RecipeHolder::value).toList());
        registration.addRecipes(InfuserRecipeCategory.INFUSER_TYPE, rm.getAllRecipesFor((RecipeType)WootRecipes.INFUSER_TYPE.get()).stream().map(RecipeHolder::value).toList());
        registration.addRecipes(FluidConvertorRecipeCategory.FLUID_CONVERTOR_TYPE, rm.getAllRecipesFor((RecipeType)WootRecipes.FLUID_CONVERTOR_TYPE.get()).stream().map(RecipeHolder::value).toList());
        registration.addRecipes(DyeSqueezerRecipeCategory.SQUEEZER_TYPE, rm.getAllRecipesFor((RecipeType)WootRecipes.DYE_SQUEEZER_TYPE.get()).stream().map(RecipeHolder::value).toList());
        registration.addRecipes(EnchantSqueezerRecipeCategory.ENCHANT_TYPE, rm.getAllRecipesFor((RecipeType)WootRecipes.ENCHANT_SQUEEZER_TYPE.get()).stream().map(RecipeHolder::value).toList());
    }
}

