/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ipsis.woot.Woot;
import ipsis.woot.modules.factory.Exotic;
import ipsis.woot.modules.factory.FactoryConfiguration;
import ipsis.woot.util.helper.RandomHelper;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;

public class ExoticDropsLootModifier
extends LootModifier {
    private int rolls;
    private double dropChance;
    private int[] weights;
    private List<WeightedEntry.Wrapper<ItemStack>> drops = new ArrayList<WeightedEntry.Wrapper<ItemStack>>();
    public static final MapCodec<ExoticDropsLootModifier> MAP_CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)LootModifier.LOOT_CONDITIONS_CODEC.fieldOf("loot").forGetter(modifier -> modifier.conditions), (App)Codec.INT.fieldOf("rolls").forGetter(modifier -> modifier.rolls), (App)Codec.DOUBLE.fieldOf("chance").forGetter(modifier -> modifier.dropChance), (App)Codec.INT.listOf().fieldOf("weights").forGetter(modifier -> Arrays.stream(modifier.weights).boxed().toList())).apply((Applicative)inst, (l, r, c, w) -> new ExoticDropsLootModifier((LootItemCondition[])l, (int)r, (double)c, w.stream().mapToInt(Integer::intValue).toArray())));

    public ExoticDropsLootModifier(LootItemCondition[] conditions, int rolls, double chance, int[] weights) {
        super(conditions);
        this.rolls = rolls;
        this.dropChance = (Double)FactoryConfiguration.EXOTIC.get();
        this.weights = weights;
        this.drops.add((WeightedEntry.Wrapper<ItemStack>)WeightedEntry.wrap((Object)Exotic.EXOTIC_A.getItemStack(), (int)weights[0]));
        this.drops.add((WeightedEntry.Wrapper<ItemStack>)WeightedEntry.wrap((Object)Exotic.EXOTIC_B.getItemStack(), (int)weights[1]));
        this.drops.add((WeightedEntry.Wrapper<ItemStack>)WeightedEntry.wrap((Object)Exotic.EXOTIC_C.getItemStack(), (int)weights[2]));
        this.drops.add((WeightedEntry.Wrapper<ItemStack>)WeightedEntry.wrap((Object)Exotic.EXOTIC_D.getItemStack(), (int)weights[3]));
        this.drops.add((WeightedEntry.Wrapper<ItemStack>)WeightedEntry.wrap((Object)Exotic.EXOTIC_E.getItemStack(), (int)weights[4]));
    }

    @Nonnull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        for (int roll = 0; roll < this.rolls; ++roll) {
            if (!RandomHelper.rollPercentage(this.dropChance, "exoticDrops")) continue;
            ItemStack drop = this.getWeightedDrop();
            if (!drop.isEmpty()) {
                generatedLoot.add((Object)drop.copy());
                continue;
            }
            Woot.setup.getLogger().error("Rolled exotic dropping as empty stack");
        }
        return generatedLoot;
    }

    private ItemStack getWeightedDrop() {
        if (WeightedRandom.getTotalWeight(this.drops) > 0) {
            ItemStack itemStack = (ItemStack)((WeightedEntry.Wrapper)WeightedRandom.getRandomItem((RandomSource)RandomHelper.RANDOM, this.drops).get()).data();
        }
        return ItemStack.EMPTY;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return MAP_CODEC;
    }
}

