/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.anvil.blocks;

import ipsis.woot.crafting.anvil.AnvilRecipe;
import ipsis.woot.modules.anvil.AnvilConfiguration;
import ipsis.woot.modules.anvil.AnvilSetup;
import ipsis.woot.modules.anvil.blocks.AnvilBlockEntity;
import ipsis.woot.modules.debug.items.DebugItem;
import ipsis.woot.util.WootDebug;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class AnvilBlock
extends Block
implements WootDebug,
EntityBlock {
    private static final VoxelShape PART_BASE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0);
    private static final VoxelShape PART_LOWER_X = Block.box((double)3.0, (double)4.0, (double)4.0, (double)13.0, (double)5.0, (double)12.0);
    private static final VoxelShape PART_MID_X = Block.box((double)4.0, (double)5.0, (double)6.0, (double)12.0, (double)10.0, (double)10.0);
    private static final VoxelShape PART_UPPER_X = Block.box((double)0.0, (double)10.0, (double)3.0, (double)16.0, (double)16.0, (double)13.0);
    private static final VoxelShape PART_LOWER_Z = Block.box((double)4.0, (double)4.0, (double)3.0, (double)12.0, (double)5.0, (double)13.0);
    private static final VoxelShape PART_MID_Z = Block.box((double)6.0, (double)5.0, (double)4.0, (double)10.0, (double)10.0, (double)12.0);
    private static final VoxelShape PART_UPPER_Z = Block.box((double)3.0, (double)10.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0);
    private static final VoxelShape X_AXIS_AABB = Shapes.or((VoxelShape)PART_BASE, (VoxelShape[])new VoxelShape[]{PART_LOWER_X, PART_MID_X, PART_UPPER_X});
    private static final VoxelShape Z_AXIS_AABB = Shapes.or((VoxelShape)PART_BASE, (VoxelShape[])new VoxelShape[]{PART_LOWER_Z, PART_MID_Z, PART_UPPER_Z});

    public AnvilBlock() {
        super(BlockBehaviour.Properties.of().sound(SoundType.METAL).strength(3.5f));
        this.registerDefaultState((BlockState)this.getStateDefinition().any());
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new AnvilBlockEntity(pos, state);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)context.getHorizontalDirection().getClockWise(Direction.Axis.Y));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING});
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        return direction.getAxis() == Direction.Axis.X ? X_AXIS_AABB : Z_AXIS_AABB;
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity te;
        if (level.isClientSide) {
            super.useItemOn(stack, state, level, pos, player, hand, hitResult);
        }
        if ((te = level.getBlockEntity(pos)) instanceof AnvilBlockEntity) {
            AnvilBlockEntity anvil = (AnvilBlockEntity)te;
            if (player.isCrouching() && stack.isEmpty()) {
                anvil.dropItem(player);
            } else if (stack.getItem() == AnvilSetup.HAMMER_ITEM.get()) {
                anvil.tryCraft(player);
            } else if (!anvil.hasBaseItem()) {
                if (AnvilRecipe.isValidInput(stack)) {
                    ItemStack baseItem = stack.copy();
                    baseItem.setCount(1);
                    anvil.setBaseItem(baseItem);
                    stack.shrink(1);
                    if (stack.isEmpty()) {
                        player.getInventory().setItem(player.getInventory().selected, ItemStack.EMPTY);
                    } else {
                        player.getInventory().setItem(player.getInventory().selected, stack);
                    }
                    player.containerMenu.broadcastChanges();
                } else {
                    player.sendSystemMessage((Component)Component.translatable((String)"chat.woot.anvil.nobase"));
                }
            } else {
                ItemStack ingredient = stack.copy();
                ingredient.setCount(1);
                if (anvil.addIngredient(ingredient)) {
                    stack.shrink(1);
                    if (stack.isEmpty()) {
                        player.getInventory().setItem(player.getInventory().selected, ItemStack.EMPTY);
                    } else {
                        player.getInventory().setItem(player.getInventory().selected, stack);
                    }
                    player.containerMenu.broadcastChanges();
                }
            }
        }
        return ItemInteractionResult.SUCCESS;
    }

    public boolean isAnvilHot(Level world, BlockPos pos) {
        return world.getBlockState(pos.below()).getBlock() == Blocks.MAGMA_BLOCK;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource random) {
        super.animateTick(stateIn, worldIn, pos, random);
        if (((Boolean)AnvilConfiguration.ANVIL_PARTICILES.get()).booleanValue() && random.nextInt(10) == 0 && this.isAnvilHot(worldIn, pos)) {
            worldIn.addParticle((ParticleOptions)ParticleTypes.LAVA, (double)((float)pos.getX() + random.nextFloat()), (double)((float)pos.getY() + 1.1f), (double)((float)pos.getZ() + random.nextFloat()), 0.0, 0.0, 0.0);
        }
    }

    public void onRemove(BlockState blockState, Level world, BlockPos pos, BlockState newBlockState, boolean isMoving) {
        if (blockState.getBlock() != newBlockState.getBlock()) {
            BlockEntity te = world.getBlockEntity(pos);
            if (te instanceof AnvilBlockEntity) {
                ((AnvilBlockEntity)te).dropContents(world, pos);
            }
            super.onRemove(blockState, world, pos, newBlockState, isMoving);
        }
    }

    @Override
    public List<String> getDebugText(List<String> debug, UseOnContext itemUseContext) {
        debug.add("====> AnvilBlock");
        DebugItem.getTileEntityDebug(debug, itemUseContext);
        return debug;
    }
}

