/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.anvil.blocks;

import ipsis.woot.crafting.WootRecipes;
import ipsis.woot.crafting.anvil.AnvilRecipe;
import ipsis.woot.crafting.anvil.AnvilRecipeInput;
import ipsis.woot.modules.anvil.AnvilSetup;
import ipsis.woot.modules.anvil.blocks.AnvilBlock;
import ipsis.woot.modules.factory.FactorySetup;
import ipsis.woot.modules.factory.blocks.ControllerBlockEntity;
import ipsis.woot.modules.factory.items.MobShardItem;
import ipsis.woot.util.FakeMob;
import ipsis.woot.util.WootDebug;
import ipsis.woot.util.helper.WorldHelper;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class AnvilBlockEntity
extends BlockEntity
implements WootDebug {
    private ItemStack baseItem = ItemStack.EMPTY;
    private ItemStack[] ingredients = new ItemStack[]{ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY};

    public AnvilBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)AnvilSetup.ANVIL_BLOCK_TILE.get(), pos, blockState);
    }

    public boolean hasBaseItem() {
        return !this.baseItem.isEmpty();
    }

    public void setBaseItem(ItemStack itemStack) {
        if (itemStack.isEmpty()) {
            return;
        }
        this.baseItem = itemStack.copy();
        this.setChanged();
        if (this.level != null) {
            WorldHelper.updateClient(this.level, this.getBlockPos());
        }
    }

    public ItemStack[] getIngredients() {
        return this.ingredients;
    }

    public ItemStack getBaseItem() {
        return this.baseItem.copy();
    }

    public boolean addIngredient(ItemStack itemStack) {
        if (itemStack.isEmpty()) {
            return false;
        }
        for (int i = 0; i < this.ingredients.length; ++i) {
            if (!this.ingredients[i].isEmpty()) continue;
            this.ingredients[i] = itemStack.copy();
            this.setChanged();
            if (this.level != null) {
                WorldHelper.updateClient(this.level, this.getBlockPos());
            }
            return true;
        }
        return false;
    }

    public void dropContents(Level world, BlockPos pos) {
        if (!this.baseItem.isEmpty()) {
            Containers.dropItemStack((Level)world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)this.baseItem);
            this.baseItem = ItemStack.EMPTY;
        }
        for (int i = 0; i < this.ingredients.length; ++i) {
            if (this.ingredients[i].isEmpty()) continue;
            Containers.dropItemStack((Level)world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)this.ingredients[i]);
            this.ingredients[i] = ItemStack.EMPTY;
        }
        this.setChanged();
        if (world != null) {
            WorldHelper.updateClient(world, pos);
        }
    }

    public void dropItem(Player playerEntity) {
        ItemStack itemStack = ItemStack.EMPTY;
        for (int i = 0; i < this.ingredients.length; ++i) {
            if (this.ingredients[i].isEmpty()) continue;
            itemStack = this.ingredients[i].copy();
            this.ingredients[i] = ItemStack.EMPTY;
            break;
        }
        if (itemStack.isEmpty() && !this.baseItem.isEmpty()) {
            itemStack = this.baseItem;
            this.baseItem = ItemStack.EMPTY;
        }
        if (!itemStack.isEmpty()) {
            this.setChanged();
            if (this.level != null) {
                WorldHelper.updateClient(this.level, this.getBlockPos());
            }
            if (!playerEntity.getInventory().add(itemStack)) {
                Containers.dropItemStack((Level)this.level, (double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ(), (ItemStack)itemStack);
            } else {
                playerEntity.containerMenu.broadcastChanges();
            }
        }
    }

    public void tryCraft(Player playerEntity) {
        if (!((AnvilBlock)AnvilSetup.ANVIL_BLOCK.get()).isAnvilHot(this.level, this.getBlockPos())) {
            playerEntity.sendSystemMessage((Component)Component.translatable((String)"chat.woot.anvil.cold"));
            return;
        }
        RecipeHolder recipe = this.level.getRecipeManager().getRecipeFor((RecipeType)WootRecipes.ANVIL_RECIPE_TYPE.get(), (RecipeInput)new AnvilRecipeInput(this.baseItem, Arrays.asList(this.ingredients)), this.level).orElse(null);
        if (recipe == null) {
            return;
        }
        ItemStack output = ((AnvilRecipe)recipe.value()).output();
        if (this.baseItem.getItem() == FactorySetup.MOB_SHARD_ITEM.get()) {
            FakeMob fakeMob = MobShardItem.getProgrammedMob(this.baseItem);
            output = ControllerBlockEntity.getItemStack(fakeMob);
        }
        this.baseItem = ItemStack.EMPTY;
        Arrays.fill(this.ingredients, ItemStack.EMPTY);
        this.setChanged();
        WorldHelper.updateClient(this.level, this.getBlockPos());
        ItemEntity itemEntity = new ItemEntity(this.level, (double)this.getBlockPos().getX(), (double)(this.getBlockPos().getY() + 1), (double)this.getBlockPos().getZ(), output);
        itemEntity.setDefaultPickUpDelay();
        this.level.addFreshEntity((Entity)itemEntity);
    }

    public void loadAdditional(CompoundTag compoundNBT, HolderLookup.Provider registries) {
        super.loadAdditional(compoundNBT, registries);
        this.readFromNBT(compoundNBT);
    }

    private void readFromNBT(CompoundTag compoundNBT) {
        if (compoundNBT.contains("BaseItem")) {
            ListTag listNBT = compoundNBT.getList("Inventory", 9);
            for (int i = 0; i < listNBT.size(); ++i) {
                CompoundTag itemTags = listNBT.getCompound(i);
                int j = itemTags.getInt("Slot");
                if (j < 0 || j >= this.ingredients.length) continue;
                this.ingredients[j] = ItemStack.parse((HolderLookup.Provider)this.level.registryAccess(), (Tag)itemTags).orElse(ItemStack.EMPTY);
            }
        }
    }

    public void saveAdditional(CompoundTag compoundNBT, HolderLookup.Provider lookupProvider) {
        super.saveAdditional(compoundNBT, lookupProvider);
        if (!this.baseItem.isEmpty()) {
            CompoundTag compoundNBT1 = new CompoundTag();
            this.baseItem.save(lookupProvider, (Tag)compoundNBT1);
            compoundNBT.put("BaseItem", (Tag)compoundNBT1);
            ListTag listNBT = new ListTag();
            for (int i = 0; i < this.ingredients.length; ++i) {
                if (this.ingredients[i].isEmpty()) continue;
                CompoundTag itemTags = new CompoundTag();
                itemTags.putInt("Slot", i);
                this.ingredients[i].save(lookupProvider, (Tag)itemTags);
                listNBT.add((Object)itemTags);
            }
            compoundNBT.put("Inventory", (Tag)listNBT);
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, (HolderLookup.Provider)this.level.registryAccess());
        return tag;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        CompoundTag compoundNBT = new CompoundTag();
        this.saveAdditional(compoundNBT, (HolderLookup.Provider)this.level.registryAccess());
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        this.loadAdditional(pkt.getTag(), lookupProvider);
    }

    @Override
    public List<String> getDebugText(List<String> debug, UseOnContext itemUseContext) {
        debug.add("====> AnvilTileEntity");
        debug.add("      base: " + String.valueOf(this.baseItem));
        for (int i = 0; i < this.ingredients.length; ++i) {
            debug.add("      ingredient: " + String.valueOf(this.ingredients[i]));
        }
        return debug;
    }
}

