/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.anvil.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import ipsis.woot.modules.anvil.blocks.AnvilBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AnvilTileEntitySpecialRenderer
implements BlockEntityRenderer<AnvilBlockEntity> {
    public static final Dispatcher DISPATCHER = new Dispatcher();

    private void renderStack(ItemStack itemStack, PoseStack poseStack, MultiBufferSource multiBufferSource, double x, double y, double z, int combinedLight, int combinedOverlay) {
        float scale = 0.2f;
        poseStack.pushPose();
        poseStack.translate(x, y, z);
        poseStack.scale(scale, scale, scale);
        poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
        Minecraft.getInstance().getItemRenderer().render(itemStack, ItemDisplayContext.FIXED, false, poseStack, multiBufferSource, combinedLight, combinedOverlay, Minecraft.getInstance().getItemRenderer().getModel(itemStack, null, null, 0));
        poseStack.popPose();
    }

    public void render(AnvilBlockEntity anvilBlockEntity, float v, PoseStack poseStack, MultiBufferSource multiBufferSource, int combinedLight, int combinedOverlay) {
        ItemStack[] ingredients;
        ItemStack itemStack = anvilBlockEntity.getBaseItem();
        if (!itemStack.isEmpty()) {
            this.renderStack(itemStack, poseStack, multiBufferSource, 0.5, 1.05f, 0.5, combinedLight, combinedOverlay);
        }
        if (!(ingredients = anvilBlockEntity.getIngredients())[0].isEmpty()) {
            this.renderStack(ingredients[0], poseStack, multiBufferSource, 0.5, 1.05f, 0.3f, combinedLight, combinedOverlay);
        }
        if (!ingredients[1].isEmpty()) {
            this.renderStack(ingredients[1], poseStack, multiBufferSource, 0.5, 1.05f, 0.7f, combinedLight, combinedOverlay);
        }
        if (!ingredients[2].isEmpty()) {
            this.renderStack(ingredients[2], poseStack, multiBufferSource, 0.5, 1.05f, 0.09999999403953552, combinedLight, combinedOverlay);
        }
        if (!ingredients[3].isEmpty()) {
            this.renderStack(ingredients[3], poseStack, multiBufferSource, 0.5, 1.05f, 0.9f, combinedLight, combinedOverlay);
        }
    }

    public static class Dispatcher
    implements BlockEntityRendererProvider<AnvilBlockEntity> {
        public BlockEntityRenderer<AnvilBlockEntity> create(BlockEntityRendererProvider.Context context) {
            return new AnvilTileEntitySpecialRenderer();
        }
    }
}

