/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.anvil.items;

import ipsis.woot.modules.anvil.AnvilSetup;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class DieItem
extends Item {
    final DieType dieType;

    public DieItem(DieType dieType) {
        super(new Item.Properties().stacksTo(1));
        this.dieType = dieType;
    }

    public DieType getDieType() {
        return this.dieType;
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return true;
    }

    public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
        return itemStack.copy();
    }

    public static ItemStack getItemStack(DieType dieType) {
        if (dieType == DieType.PLATE) {
            return new ItemStack((ItemLike)AnvilSetup.PLATE_DIE_ITEM.get());
        }
        if (dieType == DieType.SHARD) {
            return new ItemStack((ItemLike)AnvilSetup.SHARD_DIE_ITEM.get());
        }
        if (dieType == DieType.DYE) {
            return new ItemStack((ItemLike)AnvilSetup.DYE_DIE_ITEM.get());
        }
        return ItemStack.EMPTY;
    }

    public static enum DieType {
        PLATE,
        SHARD,
        DYE;

    }
}

