/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.debug.blocks;

import ipsis.woot.modules.debug.DebugSetup;
import ipsis.woot.util.WootDebug;
import ipsis.woot.util.WootFluidTank;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class DebugTankBlockEntity
extends BlockEntity
implements WootDebug {
    private Optional<WootFluidTank> inputTank = Optional.of(this.createTank());

    public DebugTankBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)DebugSetup.DEBUG_TANK_BLOCK_TILE.get(), pos, state);
    }

    private WootFluidTank createTank() {
        return new WootFluidTank(Integer.MAX_VALUE);
    }

    @Override
    public List<String> getDebugText(List<String> debug, UseOnContext itemUseContext) {
        debug.add("====> DebugTankTileEntity");
        this.inputTank.ifPresent(h -> {
            if (h.getFluid().isEmpty()) {
                debug.add("    Empty");
            } else {
                debug.add("    " + h.getFluid().getDescriptionId() + "/" + h.getFluidAmount());
            }
        });
        return debug;
    }
}

