/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.factory;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class ExporterFluidTank
implements IFluidHandler,
IFluidTank {
    public List<FluidTank> tanks = new ArrayList<FluidTank>();
    int numTanks;
    int capacity;
    int cycle = 0;

    public ExporterFluidTank(int tankNum, int capacity) {
        if (tankNum < 1 || capacity < 1) {
            throw new IllegalArgumentException("Invalid tank configuration");
        }
        this.numTanks = tankNum;
        for (int i = 0; i < tankNum; ++i) {
            this.tanks.add(new FluidTank(capacity));
        }
        this.capacity = capacity * this.numTanks;
    }

    public FluidStack getFluid() {
        return this.tanks.getFirst().getFluid();
    }

    public int getFluidAmount() {
        return this.tanks.getFirst().getFluidAmount();
    }

    public int getCapacity() {
        return this.capacity;
    }

    public boolean isFluidValid(FluidStack fluidStack) {
        for (FluidTank ft : this.tanks) {
            if (!ft.isFluidValid(fluidStack)) continue;
            return true;
        }
        return false;
    }

    public int getTanks() {
        return this.numTanks;
    }

    public FluidStack getFluidInTank(int i) {
        if (i > this.numTanks) {
            return null;
        }
        return this.tanks.get(i).getFluid();
    }

    public int getTankCapacity(int i) {
        return this.tanks.getFirst().getCapacity();
    }

    public boolean isFluidValid(int i, FluidStack fluidStack) {
        return this.tanks.get(i).isEmpty() || this.tanks.get(i).isFluidValid(fluidStack);
    }

    public int fill(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
        int total = fluidStack.getAmount();
        int filled = 0;
        for (int i = 0; i < this.numTanks; ++i) {
            if (!this.isFluidValid(i, fluidStack)) continue;
            fluidStack.shrink(filled += this.tanks.get(i).fill(fluidStack, fluidAction));
            if (filled != total) continue;
            return filled;
        }
        return filled;
    }

    public FluidStack drain(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
        int drained = 0;
        for (int i = 0; i < this.numTanks; ++i) {
            if (!FluidStack.isSameFluidSameComponents((FluidStack)fluidStack, (FluidStack)this.tanks.get(i).getFluid())) continue;
            int justDrained = this.tanks.get(i).drain(fluidStack, fluidAction).getAmount();
            drained += justDrained;
            fluidStack.shrink(justDrained);
        }
        return new FluidStack(fluidStack.getFluid(), drained);
    }

    public FluidStack drain(int max, IFluidHandler.FluidAction fluidAction) {
        for (int i = 0; i < this.numTanks; ++i) {
            if (this.tanks.get(i).isEmpty()) continue;
            return this.tanks.get(i).drain(max, fluidAction);
        }
        return FluidStack.EMPTY;
    }

    public ExporterFluidTank readFromNBT(HolderLookup.Provider lookupProvider, CompoundTag nbt) {
        this.numTanks = nbt.getInt("num");
        this.capacity = nbt.getInt("cap");
        this.tanks = new ArrayList<FluidTank>();
        ListTag tanksTag = nbt.getList("tanks", 9);
        for (int i = 0; i < this.numTanks; ++i) {
            FluidTank toAdd = new FluidTank(this.capacity / this.numTanks);
            toAdd.readFromNBT(lookupProvider, tanksTag.getCompound(i));
            this.tanks.add(toAdd);
        }
        return this;
    }

    public CompoundTag writeToNBT(HolderLookup.Provider lookupProvider, CompoundTag nbt) {
        nbt.putInt("num", this.numTanks);
        nbt.putInt("cap", this.capacity);
        ListTag tanksTag = new ListTag();
        for (int i = 0; i < this.numTanks; ++i) {
            if (this.tanks.get(i).isEmpty()) continue;
            tanksTag.add((Object)this.tanks.get(i).writeToNBT(lookupProvider, new CompoundTag()));
        }
        nbt.put("tanks", (Tag)tanksTag);
        return nbt;
    }
}

