/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.factory;

import ipsis.woot.modules.factory.FactorySetup;
import ipsis.woot.modules.factory.blocks.CellBlock;
import ipsis.woot.modules.factory.blocks.ControllerBlock;
import ipsis.woot.modules.factory.blocks.FactoryBlock;
import ipsis.woot.modules.factory.blocks.HeartBlock;
import ipsis.woot.modules.factory.blocks.UpgradeBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public enum FactoryComponent {
    FACTORY_A,
    FACTORY_B,
    FACTORY_C,
    FACTORY_D,
    FACTORY_E,
    FACTORY_CONNECT,
    FACTORY_CTR_BASE_PRI,
    FACTORY_CTR_BASE_SEC,
    FACTORY_UPGRADE,
    HEART,
    CAP_A,
    CAP_B,
    CAP_C,
    CAP_D,
    IMPORT,
    EXPORT,
    CONTROLLER,
    CELL;

    public static FactoryComponent[] VALUES;

    public String getName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public String getTranslationKey() {
        return "block.woot." + this.getName();
    }

    public static boolean isSameComponentFuzzy(FactoryComponent componentA, FactoryComponent componentB) {
        return componentA == componentB;
    }

    public Block getBlock() {
        return switch (this.ordinal()) {
            case 0 -> (FactoryBlock)FactorySetup.FACTORY_A_BLOCK.get();
            case 1 -> (FactoryBlock)FactorySetup.FACTORY_B_BLOCK.get();
            case 2 -> (FactoryBlock)FactorySetup.FACTORY_C_BLOCK.get();
            case 3 -> (FactoryBlock)FactorySetup.FACTORY_D_BLOCK.get();
            case 4 -> (FactoryBlock)FactorySetup.FACTORY_E_BLOCK.get();
            case 5 -> (FactoryBlock)FactorySetup.FACTORY_CONNECT_BLOCK.get();
            case 6 -> (FactoryBlock)FactorySetup.FACTORY_CTR_BASE_PRI_BLOCK.get();
            case 7 -> (FactoryBlock)FactorySetup.FACTORY_CTR_BASE_SEC_BLOCK.get();
            case 8 -> (UpgradeBlock)FactorySetup.FACTORY_UPGRADE_BLOCK.get();
            case 9 -> (HeartBlock)FactorySetup.HEART_BLOCK.get();
            case 10 -> (FactoryBlock)FactorySetup.CAP_A_BLOCK.get();
            case 11 -> (FactoryBlock)FactorySetup.CAP_B_BLOCK.get();
            case 12 -> (FactoryBlock)FactorySetup.CAP_C_BLOCK.get();
            case 13 -> (FactoryBlock)FactorySetup.CAP_D_BLOCK.get();
            case 14 -> (FactoryBlock)FactorySetup.IMPORT_BLOCK.get();
            case 15 -> (FactoryBlock)FactorySetup.EXPORT_BLOCK.get();
            case 16 -> (ControllerBlock)FactorySetup.CONTROLLER_BLOCK.get();
            case 17 -> (CellBlock)FactorySetup.CELL_1_BLOCK.get();
            default -> null;
        };
    }

    public List<Block> getBlocks() {
        ArrayList<Block> stacks = new ArrayList<Block>();
        if (this == CELL) {
            stacks.add((Block)FactorySetup.CELL_1_BLOCK.get());
            stacks.add((Block)FactorySetup.CELL_2_BLOCK.get());
            stacks.add((Block)FactorySetup.CELL_3_BLOCK.get());
            stacks.add((Block)FactorySetup.CELL_4_BLOCK.get());
        } else {
            stacks.add(this.getBlock());
        }
        return stacks;
    }

    public ItemStack getItemStack() {
        return switch (this.ordinal()) {
            case 0 -> new ItemStack((ItemLike)FactorySetup.FACTORY_A_BLOCK.get());
            case 1 -> new ItemStack((ItemLike)FactorySetup.FACTORY_B_BLOCK.get());
            case 2 -> new ItemStack((ItemLike)FactorySetup.FACTORY_C_BLOCK.get());
            case 3 -> new ItemStack((ItemLike)FactorySetup.FACTORY_D_BLOCK.get());
            case 4 -> new ItemStack((ItemLike)FactorySetup.FACTORY_E_BLOCK.get());
            case 5 -> new ItemStack((ItemLike)FactorySetup.FACTORY_CONNECT_BLOCK.get());
            case 6 -> new ItemStack((ItemLike)FactorySetup.FACTORY_CTR_BASE_PRI_BLOCK.get());
            case 7 -> new ItemStack((ItemLike)FactorySetup.FACTORY_CTR_BASE_SEC_BLOCK.get());
            case 8 -> new ItemStack((ItemLike)FactorySetup.FACTORY_UPGRADE_BLOCK.get());
            case 9 -> new ItemStack((ItemLike)FactorySetup.HEART_BLOCK.get());
            case 10 -> new ItemStack((ItemLike)FactorySetup.CAP_A_BLOCK.get());
            case 11 -> new ItemStack((ItemLike)FactorySetup.CAP_B_BLOCK.get());
            case 12 -> new ItemStack((ItemLike)FactorySetup.CAP_C_BLOCK.get());
            case 13 -> new ItemStack((ItemLike)FactorySetup.CAP_D_BLOCK.get());
            case 14 -> new ItemStack((ItemLike)FactorySetup.IMPORT_BLOCK.get());
            case 15 -> new ItemStack((ItemLike)FactorySetup.EXPORT_BLOCK.get());
            case 16 -> new ItemStack((ItemLike)FactorySetup.CONTROLLER_BLOCK.get());
            case 17 -> new ItemStack((ItemLike)FactorySetup.CELL_1_BLOCK.get());
            default -> null;
        };
    }

    public List<ItemStack> getStacks() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (this == CELL) {
            stacks.add(new ItemStack((ItemLike)FactorySetup.CELL_1_BLOCK.get()));
            stacks.add(new ItemStack((ItemLike)FactorySetup.CELL_2_BLOCK.get()));
            stacks.add(new ItemStack((ItemLike)FactorySetup.CELL_3_BLOCK.get()));
            stacks.add(new ItemStack((ItemLike)FactorySetup.CELL_4_BLOCK.get()));
        } else {
            stacks.add(this.getItemStack());
        }
        return stacks;
    }

    public BlockState getDefaultBlockState() {
        return switch (this.ordinal()) {
            case 0 -> ((FactoryBlock)FactorySetup.FACTORY_A_BLOCK.get()).defaultBlockState();
            case 1 -> ((FactoryBlock)FactorySetup.FACTORY_B_BLOCK.get()).defaultBlockState();
            case 2 -> ((FactoryBlock)FactorySetup.FACTORY_C_BLOCK.get()).defaultBlockState();
            case 3 -> ((FactoryBlock)FactorySetup.FACTORY_D_BLOCK.get()).defaultBlockState();
            case 4 -> ((FactoryBlock)FactorySetup.FACTORY_E_BLOCK.get()).defaultBlockState();
            case 5 -> ((FactoryBlock)FactorySetup.FACTORY_CONNECT_BLOCK.get()).defaultBlockState();
            case 6 -> ((FactoryBlock)FactorySetup.FACTORY_CTR_BASE_PRI_BLOCK.get()).defaultBlockState();
            case 7 -> ((FactoryBlock)FactorySetup.FACTORY_CTR_BASE_SEC_BLOCK.get()).defaultBlockState();
            case 8 -> ((UpgradeBlock)FactorySetup.FACTORY_UPGRADE_BLOCK.get()).defaultBlockState();
            case 10 -> ((FactoryBlock)FactorySetup.CAP_A_BLOCK.get()).defaultBlockState();
            case 11 -> ((FactoryBlock)FactorySetup.CAP_B_BLOCK.get()).defaultBlockState();
            case 12 -> ((FactoryBlock)FactorySetup.CAP_C_BLOCK.get()).defaultBlockState();
            case 13 -> ((FactoryBlock)FactorySetup.CAP_D_BLOCK.get()).defaultBlockState();
            case 14 -> ((FactoryBlock)FactorySetup.IMPORT_BLOCK.get()).defaultBlockState();
            case 15 -> ((FactoryBlock)FactorySetup.EXPORT_BLOCK.get()).defaultBlockState();
            case 16 -> ((ControllerBlock)FactorySetup.CONTROLLER_BLOCK.get()).defaultBlockState();
            case 17 -> ((CellBlock)FactorySetup.CELL_1_BLOCK.get()).defaultBlockState();
            default -> ((HeartBlock)FactorySetup.HEART_BLOCK.get()).defaultBlockState();
        };
    }

    static {
        VALUES = FactoryComponent.values();
    }
}

