/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.factory;

import ipsis.woot.Woot;
import ipsis.woot.modules.factory.Exotic;
import ipsis.woot.modules.factory.FactoryComponent;
import ipsis.woot.modules.factory.blocks.Cell1BlockEntity;
import ipsis.woot.modules.factory.blocks.Cell2BlockEntity;
import ipsis.woot.modules.factory.blocks.Cell3BlockEntity;
import ipsis.woot.modules.factory.blocks.Cell4BlockEntity;
import ipsis.woot.modules.factory.blocks.CellBlock;
import ipsis.woot.modules.factory.blocks.ControllerBlock;
import ipsis.woot.modules.factory.blocks.ControllerBlockEntity;
import ipsis.woot.modules.factory.blocks.ExoticBlock;
import ipsis.woot.modules.factory.blocks.ExporterBlock;
import ipsis.woot.modules.factory.blocks.ExporterBlockEntity;
import ipsis.woot.modules.factory.blocks.FactoryBlock;
import ipsis.woot.modules.factory.blocks.HeartBlock;
import ipsis.woot.modules.factory.blocks.HeartBlockEntity;
import ipsis.woot.modules.factory.blocks.HeartMenu;
import ipsis.woot.modules.factory.blocks.UpgradeBlock;
import ipsis.woot.modules.factory.blocks.UpgradeBlockEntity;
import ipsis.woot.modules.factory.items.ControllerBlockItem;
import ipsis.woot.modules.factory.items.MobShardItem;
import ipsis.woot.modules.factory.items.PerkItem;
import ipsis.woot.modules.factory.items.XpShardBaseItem;
import ipsis.woot.modules.factory.multiblock.MultiBlockBlockEntity;
import ipsis.woot.modules.factory.perks.Perk;
import ipsis.woot.util.WootBaseEntityBlock;
import ipsis.woot.util.WootMachineBlockEntity;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class FactorySetup {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"woot");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK, (String)"woot");
    public static final DeferredRegister<BlockEntityType<?>> BLOCKENTITIES = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (String)"woot");
    public static final DeferredRegister<MenuType<?>> CONTAINERS = DeferredRegister.create((Registry)BuiltInRegistries.MENU, (String)"woot");
    public static final DeferredHolder<Block, WootBaseEntityBlock> WOOT_BASE_BLOCK = BLOCKS.register("wootbaseblock", () -> new WootBaseEntityBlock(BlockBehaviour.Properties.of()));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<WootMachineBlockEntity>> WOOT_MACHINE_ENTITY = BLOCKENTITIES.register("wootmachineentity", () -> BlockEntityType.Builder.of(WootMachineBlockEntity::new, (Block[])new Block[]{(Block)WOOT_BASE_BLOCK.get()}).build(null));
    public static final String HEART_TAG = "heart";
    public static final DeferredHolder<Block, HeartBlock> HEART_BLOCK = BLOCKS.register("heart", () -> new HeartBlock(BlockBehaviour.Properties.of()));
    public static final DeferredHolder<Item, Item> HEART_BLOCK_ITEM = ITEMS.register("heart", () -> new BlockItem((Block)HEART_BLOCK.get(), Woot.createStandardProperties()));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<HeartBlockEntity>> HEART_BLOCK_TILE = BLOCKENTITIES.register("heart", () -> BlockEntityType.Builder.of(HeartBlockEntity::new, (Block[])new Block[]{(Block)HEART_BLOCK.get()}).build(null));
    public static final DeferredHolder<MenuType<?>, MenuType<HeartMenu>> HEART_BLOCK_CONTAINER = CONTAINERS.register("heart", () -> IMenuTypeExtension.create(HeartMenu::new));
    public static final String CONTROLLER_TAG = "controller";
    public static final DeferredHolder<Block, ControllerBlock> CONTROLLER_BLOCK = BLOCKS.register("controller", () -> new ControllerBlock(BlockBehaviour.Properties.of()));
    public static final DeferredHolder<Item, Item> CONTROLLER_BLOCK_ITEM = ITEMS.register("controller", () -> new ControllerBlockItem((Block)CONTROLLER_BLOCK.get(), Woot.createStandardProperties()));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<ControllerBlockEntity>> CONTROLLER_BLOCK_TILE = BLOCKENTITIES.register("controller", () -> BlockEntityType.Builder.of(ControllerBlockEntity::new, (Block[])new Block[]{(Block)CONTROLLER_BLOCK.get()}).build(null));
    public static final DeferredHolder<Block, FactoryBlock> FACTORY_A_BLOCK = BLOCKS.register("factory_a", () -> new FactoryBlock(FactoryComponent.FACTORY_A));
    public static final DeferredHolder<Item, Item> FACTORY_A_BLOCK_ITEM = ITEMS.register("factory_a", () -> new BlockItem((Block)FACTORY_A_BLOCK.get(), Woot.createStandardProperties()));
    public static final DeferredHolder<Block, FactoryBlock> FACTORY_B_BLOCK = BLOCKS.register("factory_b", () -> new FactoryBlock(FactoryComponent.FACTORY_B));
    public static final DeferredHolder<Item, Item> FACTORY_B_BLOCK_ITEM = ITEMS.register("factory_b", () -> new BlockItem((Block)FACTORY_B_BLOCK.get(), Woot.createStandardProperties()));
    public static final DeferredHolder<Block, FactoryBlock> FACTORY_C_BLOCK = BLOCKS.register("factory_c", () -> new FactoryBlock(FactoryComponent.FACTORY_C));
    public static final DeferredHolder<Item, Item> FACTORY_C_BLOCK_ITEM = ITEMS.register("factory_c", () -> new BlockItem((Block)FACTORY_C_BLOCK.get(), Woot.createStandardProperties()));
    public static final DeferredHolder<Block, FactoryBlock> FACTORY_D_BLOCK = BLOCKS.register("factory_d", () -> new FactoryBlock(FactoryComponent.FACTORY_D));
    public static final DeferredHolder<Item, Item> FACTORY_D_BLOCK_ITEM = ITEMS.register("factory_d", () -> new BlockItem((Block)FACTORY_D_BLOCK.get(), Woot.createStandardProperties()));
    public static final DeferredHolder<Block, FactoryBlock> FACTORY_E_BLOCK = BLOCKS.register("factory_e", () -> new FactoryBlock(FactoryComponent.FACTORY_E));
    public static final DeferredHolder<Item, Item> FACTORY_E_BLOCK_ITEM = ITEMS.register("factory_e", () -> new BlockItem((Block)FACTORY_E_BLOCK.get(), Woot.createStandardProperties()));
    public static final DeferredHolder<Block, FactoryBlock> CAP_A_BLOCK = BLOCKS.register("cap_a", () -> new FactoryBlock(FactoryComponent.CAP_A));
    public static final DeferredHolder<Item, Item> CAP_A_BLOCK_ITEM = ITEMS.register("cap_a", () -> new BlockItem((Block)CAP_A_BLOCK.get(), Woot.createStandardProperties()));
    public static final DeferredHolder<Block, FactoryBlock> CAP_B_BLOCK = BLOCKS.register("cap_b", () -> new FactoryBlock(FactoryComponent.CAP_B));
    public static final DeferredHolder<Item, Item> CAP_B_BLOCK_ITEM = ITEMS.register("cap_b", () -> new BlockItem((Block)CAP_B_BLOCK.get(), Woot.createStandardProperties()));
    public static final DeferredHolder<Block, FactoryBlock> CAP_C_BLOCK = BLOCKS.register("cap_c", () -> new FactoryBlock(FactoryComponent.CAP_C));
    public static final DeferredHolder<Item, Item> CAP_C_BLOCK_ITEM = ITEMS.register("cap_c", () -> new BlockItem((Block)CAP_C_BLOCK.get(), Woot.createStandardProperties()));
    public static final DeferredHolder<Block, FactoryBlock> CAP_D_BLOCK = BLOCKS.register("cap_d", () -> new FactoryBlock(FactoryComponent.CAP_D));
    public static final DeferredHolder<Item, Item> CAP_D_BLOCK_ITEM = ITEMS.register("cap_d", () -> new BlockItem((Block)CAP_D_BLOCK.get(), Woot.createStandardProperties()));
    public static final DeferredHolder<Block, FactoryBlock> FACTORY_CONNECT_BLOCK = BLOCKS.register("factory_connect", () -> new FactoryBlock(FactoryComponent.FACTORY_CONNECT));
    public static final DeferredHolder<Item, Item> FACTORY_CONNECT_BLOCK_ITEM = ITEMS.register("factory_connect", () -> new BlockItem((Block)FACTORY_CONNECT_BLOCK.get(), Woot.createStandardProperties()));
    public static final DeferredHolder<Block, FactoryBlock> FACTORY_CTR_BASE_PRI_BLOCK = BLOCKS.register("factory_ctr_base_pri", () -> new FactoryBlock(FactoryComponent.FACTORY_CTR_BASE_PRI));
    public static final DeferredHolder<Item, Item> FACTORY_CTR_BASE_PRI_BLOCK_ITEM = ITEMS.register("factory_ctr_base_pri", () -> new BlockItem((Block)FACTORY_CTR_BASE_PRI_BLOCK.get(), Woot.createStandardProperties()));
    public static final DeferredHolder<Block, FactoryBlock> FACTORY_CTR_BASE_SEC_BLOCK = BLOCKS.register("factory_ctr_base_sec", () -> new FactoryBlock(FactoryComponent.FACTORY_CTR_BASE_SEC));
    public static final DeferredHolder<Item, Item> FACTORY_CTR_BASE_SEC_BLOCK_ITEM = ITEMS.register("factory_ctr_base_sec", () -> new BlockItem((Block)FACTORY_CTR_BASE_SEC_BLOCK.get(), Woot.createStandardProperties()));
    public static final DeferredHolder<Block, FactoryBlock> IMPORT_BLOCK = BLOCKS.register("import", () -> new FactoryBlock(FactoryComponent.IMPORT));
    public static final DeferredHolder<Item, Item> IMPORT_BLOCK_ITEM = ITEMS.register("import", () -> new BlockItem((Block)IMPORT_BLOCK.get(), Woot.createStandardProperties()));
    public static final DeferredHolder<Block, FactoryBlock> EXPORT_BLOCK = BLOCKS.register("export", ExporterBlock::new);
    public static final DeferredHolder<Item, Item> EXPORT_BLOCK_ITEM = ITEMS.register("export", () -> new BlockItem((Block)EXPORT_BLOCK.get(), Woot.createStandardProperties()));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<ExporterBlockEntity>> EXPORTER_BLOCK_ENTITY = BLOCKENTITIES.register("exporter", () -> BlockEntityType.Builder.of(ExporterBlockEntity::new, (Block[])new Block[]{(Block)EXPORT_BLOCK.get()}).build(null));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<?>> MULTIBLOCK_BLOCK_TILE = BLOCKENTITIES.register("multiblock", () -> BlockEntityType.Builder.of(MultiBlockBlockEntity::new, (Block[])new Block[]{(Block)IMPORT_BLOCK.get(), (Block)EXPORT_BLOCK.get(), (Block)FACTORY_A_BLOCK.get(), (Block)FACTORY_B_BLOCK.get(), (Block)FACTORY_C_BLOCK.get(), (Block)FACTORY_D_BLOCK.get(), (Block)FACTORY_E_BLOCK.get(), (Block)CAP_A_BLOCK.get(), (Block)CAP_B_BLOCK.get(), (Block)CAP_C_BLOCK.get(), (Block)CAP_D_BLOCK.get(), (Block)FACTORY_CONNECT_BLOCK.get(), (Block)FACTORY_CTR_BASE_PRI_BLOCK.get(), (Block)FACTORY_CTR_BASE_SEC_BLOCK.get()}).build(null));
    public static final String FACTORY_UPGRADE_TAG = "factory_upgrade";
    public static final DeferredHolder<Block, UpgradeBlock> FACTORY_UPGRADE_BLOCK = BLOCKS.register("factory_upgrade", () -> new UpgradeBlock(FactoryComponent.FACTORY_UPGRADE));
    public static final DeferredHolder<Item, Item> FACTORY_UPGRADE_BLOCK_ITEM = ITEMS.register("factory_upgrade", () -> new BlockItem((Block)FACTORY_UPGRADE_BLOCK.get(), Woot.createStandardProperties()));
    public static final String CELL_1_TAG = "cell_1";
    public static final DeferredHolder<Block, CellBlock> CELL_1_BLOCK = BLOCKS.register("cell_1", () -> new CellBlock(Cell1BlockEntity.class));
    public static final DeferredHolder<Item, Item> CELL_1_BLOCK_ITEM = ITEMS.register("cell_1", () -> new BlockItem((Block)CELL_1_BLOCK.get(), Woot.createStandardProperties()));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<Cell1BlockEntity>> CELL_1_BLOCK_TILE = BLOCKENTITIES.register("cell_1", () -> BlockEntityType.Builder.of(Cell1BlockEntity::new, (Block[])new Block[]{(Block)CELL_1_BLOCK.get()}).build(null));
    public static final String CELL_2_TAG = "cell_2";
    public static final DeferredHolder<Block, CellBlock> CELL_2_BLOCK = BLOCKS.register("cell_2", () -> new CellBlock(Cell2BlockEntity.class));
    public static final DeferredHolder<Item, Item> CELL_2_BLOCK_ITEM = ITEMS.register("cell_2", () -> new BlockItem((Block)CELL_2_BLOCK.get(), Woot.createStandardProperties()));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<Cell2BlockEntity>> CELL_2_BLOCK_TILE = BLOCKENTITIES.register("cell_2", () -> BlockEntityType.Builder.of(Cell2BlockEntity::new, (Block[])new Block[]{(Block)CELL_2_BLOCK.get()}).build(null));
    public static final String CELL_3_TAG = "cell_3";
    public static final DeferredHolder<Block, CellBlock> CELL_3_BLOCK = BLOCKS.register("cell_3", () -> new CellBlock(Cell3BlockEntity.class));
    public static final DeferredHolder<Item, Item> CELL_3_BLOCK_ITEM = ITEMS.register("cell_3", () -> new BlockItem((Block)CELL_3_BLOCK.get(), Woot.createStandardProperties()));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<Cell3BlockEntity>> CELL_3_BLOCK_TILE = BLOCKENTITIES.register("cell_3", () -> BlockEntityType.Builder.of(Cell3BlockEntity::new, (Block[])new Block[]{(Block)CELL_3_BLOCK.get()}).build(null));
    public static final String CELL_4_TAG = "cell_4";
    public static final DeferredHolder<Block, CellBlock> CELL_4_BLOCK = BLOCKS.register("cell_4", () -> new CellBlock(Cell4BlockEntity.class));
    public static final DeferredHolder<Item, Item> CELL_4_BLOCK_ITEM = ITEMS.register("cell_4", () -> new BlockItem((Block)CELL_4_BLOCK.get(), Woot.createStandardProperties()));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<Cell4BlockEntity>> CELL_4_BLOCK_TILE = BLOCKENTITIES.register("cell_4", () -> BlockEntityType.Builder.of(Cell4BlockEntity::new, (Block[])new Block[]{(Block)CELL_4_BLOCK.get()}).build(null));
    public static final DeferredHolder<Block, ExoticBlock> EXOTIC_A_BLOCK = BLOCKS.register(Exotic.EXOTIC_A.getName(), () -> new ExoticBlock(Exotic.EXOTIC_A));
    public static final DeferredHolder<Item, Item> EXOTIC_A_BLOCK_ITEM = ITEMS.register(Exotic.EXOTIC_A.getName(), () -> new BlockItem((Block)EXOTIC_A_BLOCK.get(), Woot.createStandardProperties()));
    public static final DeferredHolder<Block, ExoticBlock> EXOTIC_B_BLOCK = BLOCKS.register(Exotic.EXOTIC_B.getName(), () -> new ExoticBlock(Exotic.EXOTIC_B));
    public static final DeferredHolder<Item, Item> EXOTIC_B_BLOCK_ITEM = ITEMS.register(Exotic.EXOTIC_B.getName(), () -> new BlockItem((Block)EXOTIC_B_BLOCK.get(), Woot.createStandardProperties()));
    public static final DeferredHolder<Block, ExoticBlock> EXOTIC_C_BLOCK = BLOCKS.register(Exotic.EXOTIC_C.getName(), () -> new ExoticBlock(Exotic.EXOTIC_C));
    public static final DeferredHolder<Item, Item> EXOTIC_C_BLOCK_ITEM = ITEMS.register(Exotic.EXOTIC_C.getName(), () -> new BlockItem((Block)EXOTIC_C_BLOCK.get(), Woot.createStandardProperties()));
    public static final DeferredHolder<Block, ExoticBlock> EXOTIC_D_BLOCK = BLOCKS.register(Exotic.EXOTIC_D.getName(), () -> new ExoticBlock(Exotic.EXOTIC_D));
    public static final DeferredHolder<Item, Item> EXOTIC_D_BLOCK_ITEM = ITEMS.register(Exotic.EXOTIC_D.getName(), () -> new BlockItem((Block)EXOTIC_D_BLOCK.get(), Woot.createStandardProperties()));
    public static final DeferredHolder<Block, ExoticBlock> EXOTIC_E_BLOCK = BLOCKS.register(Exotic.EXOTIC_E.getName(), () -> new ExoticBlock(Exotic.EXOTIC_E));
    public static final DeferredHolder<Item, Item> EXOTIC_E_BLOCK_ITEM = ITEMS.register(Exotic.EXOTIC_E.getName(), () -> new BlockItem((Block)EXOTIC_E_BLOCK.get(), Woot.createStandardProperties()));
    public static final DeferredHolder<Item, PerkItem> EFFICIENCY_1_ITEM = ITEMS.register("efficiency_1", () -> new PerkItem(Perk.efficiency_1));
    public static final DeferredHolder<Item, PerkItem> EFFICIENCY_2_ITEM = ITEMS.register("efficiency_2", () -> new PerkItem(Perk.efficiency_2));
    public static final DeferredHolder<Item, PerkItem> EFFICIENCY_3_ITEM = ITEMS.register("efficiency_3", () -> new PerkItem(Perk.efficiency_3));
    public static final DeferredHolder<Item, PerkItem> LOOTING_1_ITEM = ITEMS.register("looting_1", () -> new PerkItem(Perk.looting_1));
    public static final DeferredHolder<Item, PerkItem> LOOTING_2_ITEM = ITEMS.register("looting_2", () -> new PerkItem(Perk.looting_2));
    public static final DeferredHolder<Item, PerkItem> LOOTING_3_ITEM = ITEMS.register("looting_3", () -> new PerkItem(Perk.looting_3));
    public static final DeferredHolder<Item, PerkItem> MASS_1_ITEM = ITEMS.register("mass_1", () -> new PerkItem(Perk.mass_1));
    public static final DeferredHolder<Item, PerkItem> MASS_2_ITEM = ITEMS.register("mass_2", () -> new PerkItem(Perk.mass_2));
    public static final DeferredHolder<Item, PerkItem> MASS_3_ITEM = ITEMS.register("mass_3", () -> new PerkItem(Perk.mass_3));
    public static final DeferredHolder<Item, PerkItem> RATE_1_ITEM = ITEMS.register("rate_1", () -> new PerkItem(Perk.rate_1));
    public static final DeferredHolder<Item, PerkItem> RATE_2_ITEM = ITEMS.register("rate_2", () -> new PerkItem(Perk.rate_2));
    public static final DeferredHolder<Item, PerkItem> RATE_3_ITEM = ITEMS.register("rate_3", () -> new PerkItem(Perk.rate_3));
    public static final DeferredHolder<Item, PerkItem> TIER_SHARD_1_ITEM = ITEMS.register("tier_shard_1", () -> new PerkItem(Perk.tier_shard_1));
    public static final DeferredHolder<Item, PerkItem> TIER_SHARD_2_ITEM = ITEMS.register("tier_shard_2", () -> new PerkItem(Perk.tier_shard_2));
    public static final DeferredHolder<Item, PerkItem> TIER_SHARD_3_ITEM = ITEMS.register("tier_shard_3", () -> new PerkItem(Perk.tier_shard_3));
    public static final DeferredHolder<Item, PerkItem> XP_1_ITEM = ITEMS.register("xp_1", () -> new PerkItem(Perk.xp_1));
    public static final DeferredHolder<Item, PerkItem> XP_2_ITEM = ITEMS.register("xp_2", () -> new PerkItem(Perk.xp_2));
    public static final DeferredHolder<Item, PerkItem> XP_3_ITEM = ITEMS.register("xp_3", () -> new PerkItem(Perk.xp_3));
    public static final DeferredHolder<Item, PerkItem> HEADLESS_1_ITEM = ITEMS.register("headless_1", () -> new PerkItem(Perk.headless_1));
    public static final DeferredHolder<Item, PerkItem> HEADLESS_2_ITEM = ITEMS.register("headless_2", () -> new PerkItem(Perk.headless_2));
    public static final DeferredHolder<Item, PerkItem> HEADLESS_3_ITEM = ITEMS.register("headless_3", () -> new PerkItem(Perk.headless_3));
    public static final DeferredHolder<Item, PerkItem> SLAUGHTER_1_ITEM = ITEMS.register("slaughter_1", () -> new PerkItem(Perk.slaughter_1));
    public static final DeferredHolder<Item, PerkItem> SLAUGHTER_2_ITEM = ITEMS.register("slaughter_2", () -> new PerkItem(Perk.slaughter_2));
    public static final DeferredHolder<Item, PerkItem> SLAUGHTER_3_ITEM = ITEMS.register("slaughter_3", () -> new PerkItem(Perk.slaughter_3));
    public static final DeferredHolder<Item, PerkItem> CRUSHER_1_ITEM = ITEMS.register("crusher_1", () -> new PerkItem(Perk.crusher_1));
    public static final DeferredHolder<Item, PerkItem> CRUSHER_2_ITEM = ITEMS.register("crusher_2", () -> new PerkItem(Perk.crusher_2));
    public static final DeferredHolder<Item, PerkItem> CRUSHER_3_ITEM = ITEMS.register("crusher_3", () -> new PerkItem(Perk.crusher_3));
    public static final DeferredHolder<Item, PerkItem> LASER_1_ITEM = ITEMS.register("laser_1", () -> new PerkItem(Perk.laser_1));
    public static final DeferredHolder<Item, PerkItem> LASER_2_ITEM = ITEMS.register("laser_2", () -> new PerkItem(Perk.laser_2));
    public static final DeferredHolder<Item, PerkItem> LASER_3_ITEM = ITEMS.register("laser_3", () -> new PerkItem(Perk.laser_3));
    public static final DeferredHolder<Item, MobShardItem> MOB_SHARD_ITEM = ITEMS.register("mobshard", MobShardItem::new);
    public static final DeferredHolder<Item, XpShardBaseItem> XP_SHARD_ITEM = ITEMS.register("xpshard", () -> new XpShardBaseItem(XpShardBaseItem.Variant.SHARD));
    public static final DeferredHolder<Item, XpShardBaseItem> XP_SPLINTER_ITEM = ITEMS.register("xpsplinter", () -> new XpShardBaseItem(XpShardBaseItem.Variant.SPLINTER));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<UpgradeBlockEntity>> FACTORY_UPGRADE_BLOCK_ENTITY = BLOCKENTITIES.register("factory_upgrade", () -> BlockEntityType.Builder.of(UpgradeBlockEntity::new, (Block[])new Block[]{(Block)FACTORY_UPGRADE_BLOCK.get()}).build(null));

    public static void register(IEventBus eventBus) {
        Woot.setup.getLogger().info("FactorySetup: register");
        BLOCKS.register(eventBus);
        ITEMS.register(eventBus);
        BLOCKENTITIES.register(eventBus);
        CONTAINERS.register(eventBus);
    }

    public static List<Item> getItems() {
        return ITEMS.getEntries().stream().map(DeferredHolder::get).collect(Collectors.toUnmodifiableList());
    }
}

