/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.factory;

import ipsis.woot.Woot;
import ipsis.woot.config.Config;
import ipsis.woot.config.ConfigOverride;
import ipsis.woot.modules.factory.Exotic;
import ipsis.woot.modules.factory.FactoryComponent;
import ipsis.woot.modules.factory.FactoryConfiguration;
import ipsis.woot.modules.factory.MobParam;
import ipsis.woot.modules.factory.Tier;
import ipsis.woot.modules.factory.blocks.Cell1BlockEntity;
import ipsis.woot.modules.factory.blocks.Cell2BlockEntity;
import ipsis.woot.modules.factory.blocks.Cell3BlockEntity;
import ipsis.woot.modules.factory.blocks.Cell4BlockEntity;
import ipsis.woot.modules.factory.blocks.CellBlockEntityBase;
import ipsis.woot.modules.factory.blocks.UpgradeBlockEntity;
import ipsis.woot.modules.factory.layout.Layout;
import ipsis.woot.modules.factory.layout.PatternBlock;
import ipsis.woot.modules.factory.perks.Perk;
import ipsis.woot.simulator.spawning.SpawnController;
import ipsis.woot.util.ExtraWootCodecs;
import ipsis.woot.util.FakeMob;
import ipsis.woot.util.helper.MathHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;

public class FormedSetup {
    private Tier tier = Tier.TIER_1;
    private List<FakeMob> controllerMobs = new ArrayList<FakeMob>();
    private HashMap<Perk.Group, Integer> perks = new HashMap();
    private HashMap<FakeMob, MobParam> mobParams = new HashMap();
    private Level world;
    private BlockPos importPos = BlockPos.ZERO;
    private BlockPos exportPos = BlockPos.ZERO;
    private BlockPos cellPos = BlockPos.ZERO;
    private int cellCapacity = 0;
    private int cellType = 0;
    private double shardDropChance = 0.0;
    private int[] shardDropWeights = new int[]{0, 0, 0};
    private int perkTierShardValue = 0;
    private Exotic exotic = Exotic.NONE;
    private Boolean perkCapped = false;
    public static final StreamCodec<RegistryFriendlyByteBuf, HashMap<FakeMob, MobParam>> PARAM_MAP_CODEC = ExtraWootCodecs.mapStreamCodec(FakeMob.STREAM_CODEC, MobParam.STREAM_CODEC, HashMap::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, HashMap<Perk.Group, Integer>> GROUP_MAP_CODEC = ExtraWootCodecs.mapStreamCodec(Perk.Group.STREAM_CODEC, ByteBufCodecs.VAR_INT, HashMap::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, List<FakeMob>> MOB_LIST_CODEC = ExtraWootCodecs.listStreamCodec(FakeMob.STREAM_CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, FormedSetup> STREAM_CODEC = StreamCodec.of((buf, data) -> {
        Tier.STREAM_CODEC.encode(buf, (Object)data.tier);
        buf.writeInt(data.cellCapacity);
        MOB_LIST_CODEC.encode(buf, data.controllerMobs);
        GROUP_MAP_CODEC.encode(buf, data.perks);
        PARAM_MAP_CODEC.encode(buf, data.mobParams);
        buf.writeInt(data.exotic.ordinal());
        buf.writeDouble(data.shardDropChance);
        buf.writeVarIntArray(data.shardDropWeights);
        buf.writeBoolean(data.perkCapped.booleanValue());
        buf.writeVarInt(data.perks.size());
    }, buf -> {
        FormedSetup factorySetup = new FormedSetup();
        factorySetup.tier = (Tier)((Object)((Object)Tier.STREAM_CODEC.decode(buf)));
        factorySetup.cellCapacity = buf.readInt();
        factorySetup.controllerMobs = (List)MOB_LIST_CODEC.decode(buf);
        factorySetup.perks = (HashMap)GROUP_MAP_CODEC.decode(buf);
        factorySetup.mobParams = (HashMap)PARAM_MAP_CODEC.decode(buf);
        factorySetup.exotic = Exotic.getExotic(buf.readInt());
        factorySetup.shardDropChance = buf.readDouble();
        factorySetup.shardDropWeights = buf.readVarIntArray();
        factorySetup.perkCapped = buf.readBoolean();
        return factorySetup;
    });

    private FormedSetup() {
    }

    private FormedSetup(Level world, Tier tier) {
        this.world = world;
        this.tier = tier;
    }

    public List<FakeMob> getAllMobs() {
        return Collections.unmodifiableList(this.controllerMobs);
    }

    public Map<FakeMob, MobParam> getAllMobParams() {
        return Collections.unmodifiableMap(this.mobParams);
    }

    public Map<Perk.Group, Integer> getAllPerks() {
        return Collections.unmodifiableMap(this.perks);
    }

    public Optional<IFluidHandler> getCellFluidHandler() {
        if (this.world != null) {
            BlockEntity te = this.world.getBlockEntity(this.cellPos);
            return te != null ? Optional.ofNullable((IFluidHandler)this.world.getCapability(Capabilities.FluidHandler.BLOCK, te.getBlockPos(), null)) : Optional.empty();
        }
        return Optional.empty();
    }

    public boolean isPerkCapped() {
        return this.perkCapped;
    }

    public Exotic getExotic() {
        return this.exotic;
    }

    public boolean hasFluidIngredientExotic() {
        return this.exotic == Exotic.EXOTIC_A;
    }

    public boolean hasItemIngredientExotic() {
        return this.exotic == Exotic.EXOTIC_B;
    }

    public boolean hasConatusExotic() {
        return this.exotic == Exotic.EXOTIC_C;
    }

    public boolean hasSpawnTimExotic() {
        return this.exotic == Exotic.EXOTIC_D;
    }

    public boolean hasMassExotic() {
        return this.exotic == Exotic.EXOTIC_E;
    }

    public double getShardDropChance() {
        return this.shardDropChance;
    }

    public int getBasicShardWeight() {
        return this.shardDropWeights[0];
    }

    public int getAdvancedShardWeight() {
        return this.shardDropWeights[1];
    }

    public int getEliteShardWeight() {
        return this.shardDropWeights[2];
    }

    public int getPerkTierShardValue() {
        return this.perkTierShardValue;
    }

    public BlockPos getImportPos() {
        return this.importPos;
    }

    public BlockPos getExportPos() {
        return this.exportPos;
    }

    public Level getWorld() {
        return this.world;
    }

    public Tier getTier() {
        return this.tier;
    }

    public int getCellCapacity() {
        return this.cellCapacity;
    }

    public int getCellType() {
        return this.cellType;
    }

    public int getCellFluidAmount() {
        Optional<IFluidHandler> hdlr = this.getCellFluidHandler();
        if (hdlr.isPresent()) {
            IFluidHandler iFluidHandler = hdlr.orElseThrow(NullPointerException::new);
            return iFluidHandler.getFluidInTank(0).getAmount();
        }
        return 0;
    }

    public int getLootingLevel() {
        return MathHelper.clampLooting(this.perks.getOrDefault((Object)Perk.Group.looting, 0));
    }

    public List<Optional<IItemHandler>> getImportHandlers() {
        ArrayList<Optional<IItemHandler>> handlers = new ArrayList<Optional<IItemHandler>>();
        for (Direction facing : Direction.values()) {
            BlockEntity te;
            if (!this.world.isLoaded(this.importPos.offset(facing.getNormal())) || (te = this.world.getBlockEntity(this.importPos.offset(facing.getNormal()))) == null) continue;
            handlers.add(Optional.ofNullable((IItemHandler)this.world.getCapability(Capabilities.ItemHandler.BLOCK, te.getBlockPos(), (Object)facing.getOpposite())));
        }
        return handlers;
    }

    public List<Optional<IFluidHandler>> getImportFluidHandlers() {
        ArrayList<Optional<IFluidHandler>> handlers = new ArrayList<Optional<IFluidHandler>>();
        for (Direction facing : Direction.values()) {
            BlockEntity te;
            if (!this.world.isLoaded(this.importPos.offset(facing.getNormal())) || (te = this.world.getBlockEntity(this.importPos.offset(facing.getNormal()))) == null) continue;
            handlers.add(Optional.ofNullable((IFluidHandler)this.world.getCapability(Capabilities.FluidHandler.BLOCK, te.getBlockPos(), (Object)facing.getOpposite())));
        }
        return handlers;
    }

    public int getMaxSpawnTime() {
        int max = 0;
        for (MobParam mobParam : this.mobParams.values()) {
            if (mobParam.baseSpawnTicks <= max) continue;
            max = mobParam.baseSpawnTicks;
        }
        return max;
    }

    public int getMinRateValue() {
        boolean hasPerk = false;
        int min = Integer.MAX_VALUE;
        for (MobParam mobParam : this.mobParams.values()) {
            if (!mobParam.hasPerkRateValue() || mobParam.getPerkRateValue() >= min) continue;
            min = mobParam.getPerkRateValue();
            hasPerk = true;
        }
        return hasPerk ? min : 0;
    }

    private void setupMobParams() {
        for (FakeMob fakeMob : this.controllerMobs) {
            int perkLevel;
            MobParam param = new MobParam();
            param.baseSpawnTicks = Config.OVERRIDE.getIntegerOrDefault(fakeMob, ConfigOverride.OverrideKey.SPAWN_TICKS);
            param.baseMassCount = Config.OVERRIDE.getIntegerOrDefault(fakeMob, ConfigOverride.OverrideKey.MASS_COUNT);
            if (Config.OVERRIDE.hasOverride(fakeMob, ConfigOverride.OverrideKey.FIXED_COST)) {
                param.baseFluidCost = Config.OVERRIDE.getInteger(fakeMob, ConfigOverride.OverrideKey.FIXED_COST);
            } else {
                int healthPoints = SpawnController.get().getMobHealth(fakeMob, this.world);
                int unitsPerHealthPoint = Config.OVERRIDE.getIntegerOrDefault(fakeMob, ConfigOverride.OverrideKey.UNITS_PER_HEALTH);
                param.baseFluidCost = unitsPerHealthPoint * healthPoints;
            }
            if (this.perks.containsKey((Object)Perk.Group.efficiency) && (perkLevel = this.perks.getOrDefault((Object)Perk.Group.efficiency, 0).intValue()) > 0) {
                param.setPerkEfficiencyValue(Config.OVERRIDE.getIntegerOrDefault(fakeMob, Config.OVERRIDE.getKeyByPerk(Perk.Group.efficiency, perkLevel)));
            }
            if (this.perks.containsKey((Object)Perk.Group.mass) && (perkLevel = this.perks.getOrDefault((Object)Perk.Group.mass, 0).intValue()) > 0) {
                param.setPerkMassValue(Config.OVERRIDE.getIntegerOrDefault(fakeMob, Config.OVERRIDE.getKeyByPerk(Perk.Group.mass, perkLevel)));
            }
            if (this.perks.containsKey((Object)Perk.Group.rate) && (perkLevel = this.perks.getOrDefault((Object)Perk.Group.rate, 0).intValue()) > 0) {
                param.setPerkRateValue(Config.OVERRIDE.getIntegerOrDefault(fakeMob, Config.OVERRIDE.getKeyByPerk(Perk.Group.rate, perkLevel)));
            }
            if (this.perks.containsKey((Object)Perk.Group.xp) && (perkLevel = this.perks.getOrDefault((Object)Perk.Group.xp, 0).intValue()) > 0) {
                param.setPerkXpValue(Config.OVERRIDE.getIntegerOrDefault(fakeMob, Config.OVERRIDE.getKeyByPerk(Perk.Group.xp, perkLevel)));
            }
            if (this.perks.containsKey((Object)Perk.Group.headless) && (perkLevel = this.perks.getOrDefault((Object)Perk.Group.headless, 0).intValue()) > 0) {
                param.setPerkHeadlessValue(Config.OVERRIDE.getIntegerOrDefault(fakeMob, Config.OVERRIDE.getKeyByPerk(Perk.Group.headless, perkLevel)));
            }
            this.mobParams.put(fakeMob, param);
        }
    }

    public String toString() {
        return "FormedSetup{tier=" + String.valueOf((Object)this.tier) + ", controllerMobs=" + String.valueOf(this.controllerMobs) + ", perks=" + String.valueOf(this.perks) + ", world=" + String.valueOf(this.world) + ", importPos=" + String.valueOf(this.importPos) + ", exportPos=" + String.valueOf(this.exportPos) + ", cellPos=" + String.valueOf(this.cellPos) + ", cellCapacity=" + this.cellCapacity + ", exotic=" + String.valueOf((Object)this.exotic) + "}";
    }

    public static FormedSetup createFromValidLayout(Level world, Layout layout) {
        FormedSetup formedSetup = new FormedSetup(world, layout.getAbsolutePattern().getTier());
        for (FakeMob fakeMob : layout.getAbsolutePattern().getMobs()) {
            formedSetup.controllerMobs.add(new FakeMob(fakeMob));
        }
        for (PatternBlock pb : layout.getAbsolutePattern().getBlocks()) {
            BlockEntity te;
            if (pb.getFactoryComponent() == FactoryComponent.FACTORY_UPGRADE) {
                Perk perk;
                te = world.getBlockEntity(pb.getBlockPos());
                if (!(te instanceof UpgradeBlockEntity) || (perk = ((UpgradeBlockEntity)te).getUpgrade(world.getBlockState(pb.getBlockPos()))) == Perk.empty) continue;
                Perk.Group group = Perk.getGroup(perk);
                int perkLevel = Perk.getLevel(perk);
                if ((formedSetup.tier == Tier.TIER_1 || formedSetup.tier == Tier.TIER_2) && perkLevel > 1) {
                    perkLevel = 1;
                    formedSetup.perkCapped = true;
                } else if (formedSetup.tier == Tier.TIER_3 && perkLevel > 2) {
                    perkLevel = 2;
                    formedSetup.perkCapped = true;
                }
                Woot.setup.getLogger().debug("createFromValidLayout: adding perk {}/{}", (Object)group, (Object)perkLevel);
                formedSetup.perks.put(group, perkLevel);
                if (group != Perk.Group.tier_shard) continue;
                if (perkLevel == 1) {
                    formedSetup.perkTierShardValue = (Integer)FactoryConfiguration.TIER_SHARD_1.get();
                } else if (perkLevel == 2) {
                    formedSetup.perkTierShardValue = (Integer)FactoryConfiguration.TIER_SHARD_2.get();
                } else if (perkLevel == 3) {
                    formedSetup.perkTierShardValue = (Integer)FactoryConfiguration.TIER_SHARD_3.get();
                }
                if (formedSetup.getTier() == Tier.TIER_1) {
                    formedSetup.shardDropChance = (Double)FactoryConfiguration.T1_FARM_DROP_CHANCE.get();
                    formedSetup.shardDropWeights[0] = (Integer)((List)FactoryConfiguration.T1_FARM_DROP_SHARD_WEIGHTS.get()).get(0);
                    formedSetup.shardDropWeights[1] = (Integer)((List)FactoryConfiguration.T1_FARM_DROP_SHARD_WEIGHTS.get()).get(1);
                    formedSetup.shardDropWeights[2] = (Integer)((List)FactoryConfiguration.T1_FARM_DROP_SHARD_WEIGHTS.get()).get(2);
                    continue;
                }
                if (formedSetup.getTier() == Tier.TIER_2) {
                    formedSetup.shardDropChance = (Double)FactoryConfiguration.T2_FARM_DROP_CHANCE.get();
                    formedSetup.shardDropWeights[0] = (Integer)((List)FactoryConfiguration.T2_FARM_DROP_SHARD_WEIGHTS.get()).get(0);
                    formedSetup.shardDropWeights[1] = (Integer)((List)FactoryConfiguration.T2_FARM_DROP_SHARD_WEIGHTS.get()).get(1);
                    formedSetup.shardDropWeights[2] = (Integer)((List)FactoryConfiguration.T2_FARM_DROP_SHARD_WEIGHTS.get()).get(2);
                    continue;
                }
                if (formedSetup.getTier() == Tier.TIER_3) {
                    formedSetup.shardDropChance = (Double)FactoryConfiguration.T3_FARM_DROP_CHANCE.get();
                    formedSetup.shardDropWeights[0] = (Integer)((List)FactoryConfiguration.T3_FARM_DROP_SHARD_WEIGHTS.get()).get(0);
                    formedSetup.shardDropWeights[1] = (Integer)((List)FactoryConfiguration.T3_FARM_DROP_SHARD_WEIGHTS.get()).get(1);
                    formedSetup.shardDropWeights[2] = (Integer)((List)FactoryConfiguration.T3_FARM_DROP_SHARD_WEIGHTS.get()).get(2);
                    continue;
                }
                if (formedSetup.getTier() == Tier.TIER_4) {
                    formedSetup.shardDropChance = (Double)FactoryConfiguration.T4_FARM_DROP_CHANCE.get();
                    formedSetup.shardDropWeights[0] = (Integer)((List)FactoryConfiguration.T4_FARM_DROP_SHARD_WEIGHTS.get()).get(0);
                    formedSetup.shardDropWeights[1] = (Integer)((List)FactoryConfiguration.T4_FARM_DROP_SHARD_WEIGHTS.get()).get(1);
                    formedSetup.shardDropWeights[2] = (Integer)((List)FactoryConfiguration.T4_FARM_DROP_SHARD_WEIGHTS.get()).get(2);
                    continue;
                }
                if (formedSetup.getTier() != Tier.TIER_5) continue;
                formedSetup.shardDropChance = (Double)FactoryConfiguration.T5_FARM_DROP_CHANCE.get();
                formedSetup.shardDropWeights[0] = (Integer)((List)FactoryConfiguration.T5_FARM_DROP_SHARD_WEIGHTS.get()).get(0);
                formedSetup.shardDropWeights[1] = (Integer)((List)FactoryConfiguration.T5_FARM_DROP_SHARD_WEIGHTS.get()).get(1);
                formedSetup.shardDropWeights[2] = (Integer)((List)FactoryConfiguration.T5_FARM_DROP_SHARD_WEIGHTS.get()).get(2);
                continue;
            }
            if (pb.getFactoryComponent() == FactoryComponent.CELL) {
                formedSetup.cellPos = new BlockPos((Vec3i)pb.getBlockPos());
                te = world.getBlockEntity(pb.getBlockPos());
                if (!(te instanceof CellBlockEntityBase)) continue;
                formedSetup.cellCapacity = ((CellBlockEntityBase)te).getCapacity();
                if (te instanceof Cell1BlockEntity) {
                    formedSetup.cellType = 0;
                    continue;
                }
                if (te instanceof Cell2BlockEntity) {
                    formedSetup.cellType = 1;
                    continue;
                }
                if (te instanceof Cell3BlockEntity) {
                    formedSetup.cellType = 2;
                    continue;
                }
                if (!(te instanceof Cell4BlockEntity)) continue;
                formedSetup.cellType = 3;
                continue;
            }
            if (pb.getFactoryComponent() == FactoryComponent.IMPORT) {
                formedSetup.importPos = new BlockPos((Vec3i)pb.getBlockPos());
                continue;
            }
            if (pb.getFactoryComponent() != FactoryComponent.EXPORT) continue;
            formedSetup.exportPos = new BlockPos((Vec3i)pb.getBlockPos());
        }
        formedSetup.exotic = layout.getAbsolutePattern().getExotic();
        formedSetup.setupMobParams();
        return formedSetup;
    }
}

