/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.factory;

import ipsis.woot.modules.factory.FactoryConfiguration;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public class MobParam {
    public int baseSpawnTicks;
    public int baseMassCount;
    public int baseFluidCost;
    public int[] perkValues;
    public static final StreamCodec<RegistryFriendlyByteBuf, MobParam> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, MobParam::getBaseSpawnTicks, (StreamCodec)ByteBufCodecs.VAR_INT, MobParam::getBaseMassCount, (StreamCodec)ByteBufCodecs.VAR_INT, MobParam::getBaseFluidCost, (StreamCodec)StreamCodec.of((buf, intArray) -> {
        for (int i = 0; i < 5; ++i) {
            buf.writeVarInt(intArray[i]);
        }
    }, buf -> {
        int[] array = new int[5];
        for (int i = 0; i < 5; ++i) {
            array[i] = buf.readVarInt();
        }
        return array;
    }), MobParam::getPerkValues, MobParam::new);
    private static final int MOB_PARAM_UNDEFINED = -1;

    public MobParam(int baseSpawnTicks, int baseMassCount, int baseFluidCost, int[] perkValues) {
        this.baseSpawnTicks = baseSpawnTicks;
        this.baseMassCount = baseMassCount;
        this.baseFluidCost = baseFluidCost;
        this.perkValues = perkValues;
    }

    public MobParam() {
        this(1, 1, 1, new int[]{-1, -1, -1, -1, -1});
    }

    public int getMobCount(boolean hasMassPerk, boolean hasMassExotic) {
        if (hasMassExotic) {
            return (Integer)FactoryConfiguration.EXOTIC_E.get();
        }
        return hasMassPerk ? this.perkValues[1] : this.baseMassCount;
    }

    public boolean hasPerkEfficiencyValue() {
        return this.perkValues[0] != -1;
    }

    public boolean hasPerkRateValue() {
        return this.perkValues[2] != -1;
    }

    public boolean hasPerkXpValue() {
        return this.perkValues[3] != -1;
    }

    public boolean hasPerkHeadlessValue() {
        return this.perkValues[4] != -1;
    }

    public int getBaseSpawnTicks() {
        return this.baseSpawnTicks;
    }

    public int getBaseMassCount() {
        return this.baseMassCount;
    }

    public int getBaseFluidCost() {
        return this.baseFluidCost;
    }

    public int[] getPerkValues() {
        return this.perkValues;
    }

    public int getPerkEfficiencyValue() {
        return this.perkValues[0];
    }

    public int getPerkMassValue() {
        return this.perkValues[1];
    }

    public int getPerkRateValue() {
        return this.perkValues[2];
    }

    public int getPerkXpValue() {
        return this.perkValues[3];
    }

    public int getPerkHeadlessValue() {
        return this.perkValues[4];
    }

    public void setPerkEfficiencyValue(int v) {
        this.perkValues[0] = v;
    }

    public void setPerkMassValue(int v) {
        this.perkValues[1] = v;
    }

    public void setPerkRateValue(int v) {
        this.perkValues[2] = v;
    }

    public void setPerkXpValue(int v) {
        this.perkValues[3] = v;
    }

    public void setPerkHeadlessValue(int v) {
        this.perkValues[4] = v;
    }

    public void setBaseSpawnTicks(int v) {
        this.baseSpawnTicks = v;
    }

    public String toString() {
        return "MobParam{baseSpawnTicks=" + this.baseSpawnTicks + ", baseMassCount=" + this.baseMassCount + ", baseFluidCost=" + this.baseFluidCost + ", perkEfficiencyValue=" + this.perkValues[0] + ", perkMassValue=" + this.perkValues[1] + ", perkRateValue=" + this.perkValues[2] + ", perkXpValue=" + this.perkValues[3] + ", perkHeadlessValue=" + this.perkValues[4] + "}";
    }
}

