/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.factory;

import ipsis.woot.util.ExtraWootCodecs;
import java.util.EnumSet;
import java.util.Locale;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public enum Tier {
    UNKNOWN,
    TIER_1,
    TIER_2,
    TIER_3,
    TIER_4,
    TIER_5;

    static final EnumSet<Tier> VALID_FOR_TIER_1;
    static final EnumSet<Tier> VALID_FOR_TIER_2;
    static final EnumSet<Tier> VALID_FOR_TIER_3;
    static final EnumSet<Tier> VALID_FOR_TIER_4;
    static final EnumSet<Tier> VALID_FOR_TIER_5;
    public static final EnumSet<Tier> VALID_TIERS;
    public static Tier[] VALUES;
    public static final StreamCodec<RegistryFriendlyByteBuf, Tier> STREAM_CODEC;

    public static Tier byIndex(int index) {
        if (index < 0 && index >= Tier.values().length) {
            return UNKNOWN;
        }
        return Tier.values()[index];
    }

    public Tier getNextValid() {
        Tier next = VALUES[(this.ordinal() + 1) % VALUES.length];
        if (next == UNKNOWN) {
            next = VALUES[(UNKNOWN.ordinal() + 1) % VALUES.length];
        }
        return next;
    }

    public static int getMaxTier() {
        return VALUES.length - 1;
    }

    public boolean isValidForTier(Tier check) {
        if (this == TIER_1) {
            return VALID_FOR_TIER_1.contains((Object)check);
        }
        if (this == TIER_2) {
            return VALID_FOR_TIER_2.contains((Object)check);
        }
        if (this == TIER_3) {
            return VALID_FOR_TIER_3.contains((Object)check);
        }
        if (this == TIER_4) {
            return VALID_FOR_TIER_4.contains((Object)check);
        }
        if (this == TIER_5) {
            return VALID_FOR_TIER_5.contains((Object)check);
        }
        return false;
    }

    public String getTranslationKey() {
        return "misc.woot." + this.name().toLowerCase(Locale.ROOT);
    }

    static {
        VALID_FOR_TIER_1 = EnumSet.of(TIER_1);
        VALID_FOR_TIER_2 = EnumSet.range(TIER_1, TIER_2);
        VALID_FOR_TIER_3 = EnumSet.range(TIER_1, TIER_3);
        VALID_FOR_TIER_4 = EnumSet.range(TIER_1, TIER_4);
        VALID_FOR_TIER_5 = EnumSet.range(TIER_1, TIER_5);
        VALID_TIERS = EnumSet.range(TIER_1, TIER_5);
        VALUES = Tier.values();
        STREAM_CODEC = ExtraWootCodecs.enumStreamCodec(Tier.class);
    }
}

