/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.factory.blocks;

import ipsis.woot.Woot;
import ipsis.woot.modules.debug.items.DebugItem;
import ipsis.woot.modules.factory.FactoryComponent;
import ipsis.woot.modules.factory.FactoryComponentProvider;
import ipsis.woot.modules.factory.FactoryConfiguration;
import ipsis.woot.modules.factory.FactorySetup;
import ipsis.woot.modules.factory.blocks.CellBlockEntityBase;
import ipsis.woot.util.WootDebug;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CellBlock
extends Block
implements WootDebug,
FactoryComponentProvider,
EntityBlock {
    final Class<? extends CellBlockEntityBase> tileEntityClazz;

    public CellBlock(Class<? extends CellBlockEntityBase> clazz) {
        super(BlockBehaviour.Properties.of().sound(SoundType.METAL).strength(3.5f));
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BlockStateProperties.ATTACHED, (Comparable)Boolean.valueOf(false)));
        this.tileEntityClazz = clazz;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.ATTACHED});
    }

    @NotNull
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult p_225533_6_) {
        if (level.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        if (!(level.getBlockEntity(pos) instanceof CellBlockEntityBase)) {
            throw new IllegalStateException("Tile entity is missing");
        }
        CellBlockEntityBase cb = (CellBlockEntityBase)level.getBlockEntity(pos);
        Woot.setup.getLogger().debug((Object)cb.tank.getCapacity());
        Woot.setup.getLogger().debug(level.getCapability(Capabilities.FluidHandler.BLOCK, pos, null));
        if (FluidUtil.getFluidHandler((ItemStack)stack).isPresent()) {
            return FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)handIn, (Level)level, (BlockPos)pos, null) ? ItemInteractionResult.SUCCESS : ItemInteractionResult.FAIL;
        }
        return super.useItemOn(stack, state, level, pos, player, handIn, p_225533_6_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        CompoundTag compoundNBT;
        super.appendHoverText(stack, context, tooltip, flagIn);
        int transfer = 0;
        int capacity = 0;
        if (stack.getItem() == ((CellBlock)FactorySetup.CELL_1_BLOCK.get()).asItem()) {
            capacity = (Integer)FactoryConfiguration.CELL_1_CAPACITY.get();
            transfer = (Integer)FactoryConfiguration.CELL_1_MAX_TRANSFER.get();
        } else if (stack.getItem() == ((CellBlock)FactorySetup.CELL_2_BLOCK.get()).asItem()) {
            capacity = (Integer)FactoryConfiguration.CELL_2_CAPACITY.get();
            transfer = (Integer)FactoryConfiguration.CELL_2_MAX_TRANSFER.get();
        } else if (stack.getItem() == ((CellBlock)FactorySetup.CELL_3_BLOCK.get()).asItem()) {
            capacity = (Integer)FactoryConfiguration.CELL_3_CAPACITY.get();
            transfer = (Integer)FactoryConfiguration.CELL_3_MAX_TRANSFER.get();
        } else if (stack.getItem() == ((CellBlock)FactorySetup.CELL_4_BLOCK.get()).asItem()) {
            capacity = (Integer)FactoryConfiguration.CELL_4_CAPACITY.get();
            transfer = (Integer)FactoryConfiguration.CELL_4_MAX_TRANSFER.get();
        }
        int contents = 0;
        CustomData data = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
        CompoundTag compoundTag = compoundNBT = data == null ? new CompoundTag() : data.copyTag();
        if (compoundNBT.contains("Tank")) {
            FluidStack fluidStack = (FluidStack)FluidStack.parse((HolderLookup.Provider)context.registries(), (Tag)compoundNBT.getCompound("Tank")).get();
            contents = fluidStack.getAmount();
        }
        tooltip.add((Component)Component.translatable((String)"info.woot.cell.0", (Object[])new Object[]{contents, capacity}));
        tooltip.add((Component)Component.translatable((String)"info.woot.cell.1", (Object[])new Object[]{transfer}));
    }

    @Override
    public FactoryComponent getFactoryComponent() {
        return FactoryComponent.CELL;
    }

    @Override
    public List<String> getDebugText(List<String> debug, UseOnContext itemUseContext) {
        debug.add("====> CellBlock");
        DebugItem.getTileEntityDebug(debug, itemUseContext);
        return debug;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        try {
            return this.tileEntityClazz.getDeclaredConstructor(BlockPos.class, BlockState.class).newInstance(blockPos, blockState);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

