/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.factory.blocks;

import ipsis.woot.fluilds.FluidSetup;
import ipsis.woot.modules.factory.multiblock.MultiBlockBlockEntity;
import ipsis.woot.util.WootDebug;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public abstract class CellBlockEntityBase
extends MultiBlockBlockEntity
implements WootDebug {
    protected FluidTank tank = new FluidTank(1000);

    public CellBlockEntityBase(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
        this.tank.setCapacity(this.getCapacity());
        this.tank.setValidator(e -> e.getFluid() == ((BaseFlowingFluid)FluidSetup.CONATUS_FLUID.get()).getSource());
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.readFromNBT(registries, tag);
    }

    private void readFromNBT(HolderLookup.Provider registries, CompoundTag compound) {
        if (compound.contains("Tank")) {
            this.tank.readFromNBT(registries, compound.getCompound("Tank"));
        }
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        CompoundTag tankNBT = new CompoundTag();
        this.tank.writeToNBT(registries, tankNBT);
        compound.put("Tank", (Tag)tankNBT);
    }

    public void fillToCapacity() {
        this.tank.fill(new FluidStack((Fluid)FluidSetup.CONATUS_FLUID.get(), this.getCapacity()), IFluidHandler.FluidAction.EXECUTE);
    }

    public abstract int getCapacity();

    public abstract int getMaxTransfer();

    @Override
    public List<String> getDebugText(List<String> debug, UseOnContext itemUseContext) {
        debug.add("====> CellTileEntity");
        debug.add("      hasMaster: " + this.glue.hasMaster());
        debug.add("      capacity: " + this.tank.getCapacity());
        debug.add("      transfer: " + this.getMaxTransfer());
        debug.add("      contains: " + this.tank.getFluid().getDescriptionId());
        debug.add("      contains: " + this.tank.getFluid().getAmount());
        return debug;
    }
}

