/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.factory.blocks;

import ipsis.woot.modules.debug.items.DebugItem;
import ipsis.woot.modules.factory.FactoryComponent;
import ipsis.woot.modules.factory.FactoryComponentProvider;
import ipsis.woot.modules.factory.FactorySetup;
import ipsis.woot.modules.factory.Tier;
import ipsis.woot.modules.factory.blocks.ControllerBlockEntity;
import ipsis.woot.util.FakeMob;
import ipsis.woot.util.WootDebug;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ControllerBlock
extends Block
implements FactoryComponentProvider,
WootDebug,
EntityBlock {
    private final VoxelShape shape = Shapes.box((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);

    public ControllerBlock(BlockBehaviour.Properties prop) {
        super(BlockBehaviour.Properties.of().sound(SoundType.METAL).strength(3.5f));
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BlockStateProperties.ATTACHED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.ATTACHED});
    }

    @NotNull
    public VoxelShape getCollisionShape(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.ATTACHED)).booleanValue()) {
            return Shapes.block();
        }
        return this.shape;
    }

    @NotNull
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        Tier tier;
        if (level.isClientSide) {
            return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
        }
        BlockEntity te = level.getBlockEntity(pos);
        if (te instanceof ControllerBlockEntity && (tier = ((ControllerBlockEntity)te).getTier()) != Tier.UNKNOWN) {
            player.sendSystemMessage((Component)Component.translatable((String)tier.getTranslationKey()));
        }
        return ItemInteractionResult.SUCCESS;
    }

    @Override
    public FactoryComponent getFactoryComponent() {
        return FactoryComponent.CONTROLLER;
    }

    @Override
    public List<String> getDebugText(List<String> debug, UseOnContext itemUseContext) {
        debug.add("====> ControllerBlock");
        DebugItem.getTileEntityDebug(debug, itemUseContext);
        return debug;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new ControllerBlockEntity(blockPos, blockState);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (data != null) {
            ControllerBlockEntity cbe = (ControllerBlockEntity)level.getBlockEntity(pos, (BlockEntityType)FactorySetup.CONTROLLER_BLOCK_TILE.get()).get();
            cbe.setFakeMob(new FakeMob(data.copyTag()));
        }
    }
}

