/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.factory.blocks;

import ipsis.woot.config.Config;
import ipsis.woot.modules.factory.FactorySetup;
import ipsis.woot.modules.factory.Tier;
import ipsis.woot.modules.factory.multiblock.MultiBlockBlockEntity;
import ipsis.woot.util.FakeMob;
import ipsis.woot.util.WootDebug;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class ControllerBlockEntity
extends MultiBlockBlockEntity
implements WootDebug {
    private FakeMob fakeMob = new FakeMob();

    public ControllerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FactorySetup.CONTROLLER_BLOCK_TILE.get(), pos, state);
    }

    public void saveAdditional(CompoundTag compoundNBT, HolderLookup.Provider registries) {
        super.saveAdditional(compoundNBT, registries);
        CompoundTag nbt = new CompoundTag();
        FakeMob.writeToNBT(this.fakeMob, nbt);
        compoundNBT.put("Mob", (Tag)nbt);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.readFromNBT(tag);
    }

    private void readFromNBT(CompoundTag compoundNBT) {
        if (compoundNBT.contains("Mob")) {
            CompoundTag nbt = compoundNBT.getCompound("Mob");
            this.fakeMob = new FakeMob(nbt);
        }
    }

    public FakeMob getFakeMob() {
        return this.fakeMob;
    }

    public void setFakeMob(FakeMob fakeMob) {
        this.fakeMob = fakeMob;
    }

    public Tier getTier() {
        if (this.fakeMob == null || !this.fakeMob.isValid()) {
            return Tier.UNKNOWN;
        }
        return Config.OVERRIDE.getMobTier(this.fakeMob, this.level);
    }

    public static ItemStack getItemStack(FakeMob fakeMob) {
        ItemStack itemStack = new ItemStack((ItemLike)FactorySetup.CONTROLLER_BLOCK.get());
        CompoundTag nbt = new CompoundTag();
        FakeMob.writeToNBT(fakeMob, nbt);
        itemStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)nbt));
        return itemStack;
    }

    @Override
    public List<String> getDebugText(List<String> debug, UseOnContext itemUseContext) {
        debug.add("====> ControllerTileEntity");
        debug.add("      hasMaster: " + this.glue.hasMaster());
        debug.add("      mob: " + String.valueOf(this.fakeMob));
        return debug;
    }
}

