/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.factory.blocks;

import ipsis.woot.modules.factory.Exotic;
import ipsis.woot.modules.factory.FactoryConfiguration;
import ipsis.woot.modules.factory.FactorySetup;
import ipsis.woot.modules.factory.blocks.HeartBlockEntity;
import ipsis.woot.util.WootDebug;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class ExoticBlock
extends Block
implements WootDebug {
    private final Exotic exotic;

    public ExoticBlock(Exotic exotic) {
        super(BlockBehaviour.Properties.of().sound(SoundType.METAL).strength(3.5f));
        this.exotic = exotic;
    }

    public Exotic getExotic() {
        return this.exotic;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity te;
        super.setPlacedBy(level, pos, state, placer, stack);
        if (!level.isClientSide && (te = level.getBlockEntity(pos.below())) instanceof HeartBlockEntity) {
            ((HeartBlockEntity)te).interrupt();
        }
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity te;
        super.playerWillDestroy(level, pos, state, player);
        if (level.isClientSide && (te = level.getBlockEntity(pos.below())) instanceof HeartBlockEntity) {
            ((HeartBlockEntity)te).interrupt();
        }
        return state;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        tooltip.add((Component)Component.translatable((String)"info.woot.exotic.0"));
        if (stack.getItem() == FactorySetup.EXOTIC_A_BLOCK_ITEM.get()) {
            tooltip.add((Component)Component.translatable((String)"info.woot.exotic.exotic_a", (Object[])new Object[]{FactoryConfiguration.EXOTIC_A.get()}));
        } else if (stack.getItem() == FactorySetup.EXOTIC_B_BLOCK_ITEM.get()) {
            tooltip.add((Component)Component.translatable((String)"info.woot.exotic.exotic_b", (Object[])new Object[]{FactoryConfiguration.EXOTIC_B.get()}));
        } else if (stack.getItem() == FactorySetup.EXOTIC_C_BLOCK_ITEM.get()) {
            tooltip.add((Component)Component.translatable((String)"info.woot.exotic.exotic_c", (Object[])new Object[]{FactoryConfiguration.EXOTIC_C.get()}));
        } else if (stack.getItem() == FactorySetup.EXOTIC_D_BLOCK_ITEM.get()) {
            tooltip.add((Component)Component.translatable((String)"info.woot.exotic.exotic_d", (Object[])new Object[]{FactoryConfiguration.EXOTIC_D.get()}));
        } else if (stack.getItem() == FactorySetup.EXOTIC_E_BLOCK_ITEM.get()) {
            tooltip.add((Component)Component.translatable((String)"info.woot.exotic.exotic_e", (Object[])new Object[]{FactoryConfiguration.EXOTIC_E.get()}));
        }
    }

    @Override
    public List<String> getDebugText(List<String> debug, UseOnContext itemUseContext) {
        debug.add("====> ExoticBlock (" + String.valueOf((Object)this.exotic) + ")");
        return debug;
    }
}

