/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.factory.blocks;

import ipsis.woot.modules.factory.ExporterFluidTank;
import ipsis.woot.modules.factory.FactorySetup;
import ipsis.woot.modules.factory.multiblock.MultiBlockBlockEntity;
import ipsis.woot.util.helper.StorageHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public class ExporterBlockEntity
extends MultiBlockBlockEntity {
    static int LAZY_TICK = 40;
    static int FLUID_ROTATION_TICK = 200;
    int tick = 0;
    int cycleTick = 0;
    ExporterFluidTank fluidOutputHandler;
    ItemStackHandler stackOutputHandler = new ItemStackHandler(27);

    public ExporterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FactorySetup.EXPORTER_BLOCK_ENTITY.get(), pos, state);
        this.fluidOutputHandler = new ExporterFluidTank(4, 10000);
    }

    public void tick() {
        ++this.tick;
        ++this.cycleTick;
        if (this.cycleTick > FLUID_ROTATION_TICK) {
            this.fluidOutputHandler.tanks.add(this.fluidOutputHandler.tanks.removeFirst());
            this.cycleTick = 0;
        }
        if (this.tick < LAZY_TICK) {
            return;
        }
        this.tick = 0;
        ArrayList<Optional<IItemHandler>> handlers = new ArrayList<Optional<IItemHandler>>();
        for (Direction facing : Direction.values()) {
            BlockEntity te;
            if (!this.level.isLoaded(this.getBlockPos().offset(facing.getNormal())) || (te = this.level.getBlockEntity(this.getBlockPos().offset(facing.getNormal()))) == null || te instanceof MultiBlockBlockEntity) continue;
            handlers.add(Optional.ofNullable((IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, te.getBlockPos(), (Object)facing.getOpposite())));
        }
        StorageHelper.insertItems(this.stackOutputHandler, handlers);
    }

    public List<Optional<IItemHandler>> getExportHandlers() {
        ArrayList<Optional<IItemHandler>> handlers = new ArrayList<Optional<IItemHandler>>();
        for (Direction facing : Direction.values()) {
            BlockEntity te;
            if (!this.level.isLoaded(this.getBlockPos().offset(facing.getNormal())) || (te = this.level.getBlockEntity(this.getBlockPos().offset(facing.getNormal()))) == null) continue;
            handlers.add(Optional.ofNullable((IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, te.getBlockPos(), (Object)facing.getOpposite())));
        }
        return handlers;
    }

    public void insertStacks(List<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            ItemStack currStack = stack.copy();
            for (int i = 0; !(i >= this.stackOutputHandler.getSlots() || this.stackOutputHandler.isItemValid(i, stack) && (currStack = this.stackOutputHandler.insertItem(i, stack, false)).getCount() == 0); ++i) {
            }
        }
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        tag.put("OutputInventory", (Tag)this.stackOutputHandler.serializeNBT(registries));
        tag.put("OutputTank", (Tag)this.fluidOutputHandler.writeToNBT(registries, new CompoundTag()));
        super.saveAdditional(tag, registries);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        if (tag.contains("OutputInventory")) {
            this.stackOutputHandler.deserializeNBT(registries, tag.getCompound("OutputInventory"));
        }
        if (tag.contains("OutputTank")) {
            this.fluidOutputHandler.readFromNBT(registries, tag.getCompound("OutputTank"));
        }
        super.loadAdditional(tag, registries);
    }

    public void insertFluids(List<FluidStack> fluids) {
        for (FluidStack stack : fluids) {
            this.fluidOutputHandler.fill(stack, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)FactorySetup.EXPORTER_BLOCK_ENTITY.get(), (be, direction) -> be.stackOutputHandler);
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)FactorySetup.EXPORTER_BLOCK_ENTITY.get(), (be, direction) -> be.fluidOutputHandler);
    }
}

