/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.factory.blocks;

import com.mojang.serialization.MapCodec;
import ipsis.woot.modules.debug.items.DebugItem;
import ipsis.woot.modules.factory.FactoryComponent;
import ipsis.woot.modules.factory.FactoryComponentProvider;
import ipsis.woot.modules.factory.FactorySetup;
import ipsis.woot.modules.factory.multiblock.MultiBlockBlockEntity;
import ipsis.woot.util.WootDebug;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FactoryBlock
extends Block
implements FactoryComponentProvider,
WootDebug,
EntityBlock {
    private final FactoryComponent component;
    public static final String FACTORY_A_REGNAME = "factory_a";
    public static final String FACTORY_B_REGNAME = "factory_b";
    public static final String FACTORY_C_REGNAME = "factory_c";
    public static final String FACTORY_D_REGNAME = "factory_d";
    public static final String FACTORY_E_REGNAME = "factory_e";
    public static final String CAP_A_REGNAME = "cap_a";
    public static final String CAP_B_REGNAME = "cap_b";
    public static final String CAP_C_REGNAME = "cap_c";
    public static final String CAP_D_REGNAME = "cap_d";
    public static final String FACTORY_CONNECT_REGNAME = "factory_connect";
    public static final String FACTORY_CTR_BASE_PRI_REGNAME = "factory_ctr_base_pri";
    public static final String FACTORY_CTR_BASE_SEC_REGNAME = "factory_ctr_base_sec";
    public static final String IMPORT_REGNAME = "import";
    public static final String EXPORT_REGNAME = "export";
    private final VoxelShape shape = Block.box((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);

    public FactoryBlock(FactoryComponent component) {
        super(BlockBehaviour.Properties.of().sound(SoundType.STONE).strength(3.5f));
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BlockStateProperties.ATTACHED, (Comparable)Boolean.valueOf(false)));
        this.component = component;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.ATTACHED});
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (this.component == FactoryComponent.FACTORY_UPGRADE) {
            return super.getShape(state, level, pos, context);
        }
        if (((Boolean)state.getValue((Property)BlockStateProperties.ATTACHED)).booleanValue()) {
            return Shapes.block();
        }
        return this.shape;
    }

    @Override
    public FactoryComponent getFactoryComponent() {
        return this.component;
    }

    @Override
    public List<String> getDebugText(List<String> debug, UseOnContext itemUseContext) {
        debug.add("====> FactoryBlock (" + String.valueOf((Object)this.component) + ")");
        DebugItem.getTileEntityDebug(debug, itemUseContext);
        return debug;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new MultiBlockBlockEntity((BlockEntityType)FactorySetup.MULTIBLOCK_BLOCK_TILE.get(), blockPos, blockState);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return null;
    }
}

