/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.factory.blocks;

import ipsis.woot.modules.debug.DebugSetup;
import ipsis.woot.modules.debug.items.DebugItem;
import ipsis.woot.modules.factory.FactoryComponent;
import ipsis.woot.modules.factory.FactoryComponentProvider;
import ipsis.woot.modules.factory.blocks.HeartBlockEntity;
import ipsis.woot.modules.layout.LayoutSetup;
import ipsis.woot.util.WootBaseEntityBlock;
import ipsis.woot.util.WootDebug;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HeartBlock
extends WootBaseEntityBlock
implements FactoryComponentProvider,
WootDebug {
    public HeartBlock(BlockBehaviour.Properties properties) {
        super(BlockBehaviour.Properties.of().sound(SoundType.METAL).strength(3.5f));
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH));
    }

    @javax.annotation.Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING});
    }

    @NotNull
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (level.isClientSide || hand == InteractionHand.OFF_HAND) {
            return ItemInteractionResult.SUCCESS;
        }
        if (player.isCrouching()) {
            return ItemInteractionResult.FAIL;
        }
        if (player.getItemInHand(hand).getItem() == LayoutSetup.INTERN_ITEM.get() || player.getItemInHand(hand).getItem() == DebugSetup.DEBUG_ITEM.get()) {
            return ItemInteractionResult.FAIL;
        }
        BlockEntity te = level.getBlockEntity(pos);
        if (te instanceof HeartBlockEntity && !((HeartBlockEntity)te).isFormed()) {
            return ItemInteractionResult.FAIL;
        }
        if (!(te instanceof HeartBlockEntity)) {
            throw new IllegalStateException("Named container provider is missing");
        }
        player.openMenu((MenuProvider)((HeartBlockEntity)te), te.getBlockPos());
        return ItemInteractionResult.CONSUME;
    }

    @Override
    public FactoryComponent getFactoryComponent() {
        return FactoryComponent.HEART;
    }

    @Override
    public List<String> getDebugText(List<String> debug, UseOnContext itemUseContext) {
        debug.add("====> HeartBlock");
        DebugItem.getTileEntityDebug(debug, itemUseContext);
        return debug;
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new HeartBlockEntity(blockPos, blockState);
    }
}

