/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.factory.blocks;

import ipsis.woot.Woot;
import ipsis.woot.fluilds.FluidSetup;
import ipsis.woot.modules.factory.Exotic;
import ipsis.woot.modules.factory.FactoryConfiguration;
import ipsis.woot.modules.factory.FactorySetup;
import ipsis.woot.modules.factory.FormedSetup;
import ipsis.woot.modules.factory.Tier;
import ipsis.woot.modules.factory.blocks.HeartMenu;
import ipsis.woot.modules.factory.blocks.HeartRecipe;
import ipsis.woot.modules.factory.calculators.CalculatorVersion2;
import ipsis.woot.modules.factory.client.ClientFactorySetup;
import ipsis.woot.modules.factory.generators.LootGeneration;
import ipsis.woot.modules.factory.layout.Layout;
import ipsis.woot.modules.factory.multiblock.MultiBlockMaster;
import ipsis.woot.modules.factory.network.HeartStaticDataReply;
import ipsis.woot.modules.factory.perks.Perk;
import ipsis.woot.simulator.MobSimulator;
import ipsis.woot.util.FakeMob;
import ipsis.woot.util.WootDebug;
import ipsis.woot.util.WootMachineBlockEntity;
import ipsis.woot.util.helper.StorageHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class HeartBlockEntity
extends WootMachineBlockEntity
implements MultiBlockMaster,
WootDebug,
MenuProvider {
    static final Logger LOGGER = LogManager.getLogger();
    static final int LAZY_TICK_RATE = 5;
    Layout layout;
    FormedSetup formedSetup;
    HeartRecipe recipe;
    TickTracker tickTracker = new TickTracker(this);
    boolean loadedFromNBT = false;
    int tick = 0;
    int consumedUnits = 0;
    @OnlyIn(value=Dist.CLIENT)
    public ClientFactorySetup clientFactorySetup;

    public HeartBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)FactorySetup.HEART_BLOCK_TILE.get(), pos, blockState);
        this.tickTracker.setStructureTickCount(20);
    }

    public void setRemoved() {
        super.setRemoved();
        if (this.layout != null) {
            this.layout.fullDisconnect();
        }
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        if (this.layout != null) {
            this.layout.fullDisconnect();
        }
    }

    public boolean isRunning() {
        return !this.level.hasNeighborSignal(this.getBlockPos());
    }

    public boolean isFormed() {
        return this.layout != null && this.layout.isFormed();
    }

    @Override
    public void tick(Level level) {
        if (++this.tick <= 5) {
            return;
        }
        this.tick = 0;
        if (level == null) {
            return;
        }
        if (level.isClientSide) {
            return;
        }
        if (this.layout == null) {
            this.layout = new Layout();
            this.layout.setLocation(level, this.getBlockPos(), (Direction)level.getBlockState(this.getBlockPos()).getValue((Property)BlockStateProperties.HORIZONTAL_FACING));
            this.layout.setDirty();
        }
        if (!this.tickTracker.tick(level)) {
            return;
        }
        this.layout.tick(this.tickTracker, this);
        if (this.layout.isFormed()) {
            if (this.layout.hasChanged()) {
                this.formedSetup = FormedSetup.createFromValidLayout(level, this.layout);
                LOGGER.debug("formedSetup: {}", (Object)this.formedSetup);
                this.formedSetup.getAllMobs().forEach(m -> MobSimulator.getInstance().learn((FakeMob)m));
                this.recipe = CalculatorVersion2.calculate(this.formedSetup);
                if (this.loadedFromNBT) {
                    this.loadedFromNBT = false;
                } else {
                    this.consumedUnits = 0;
                    this.setChanged();
                }
                this.layout.clearChanged();
            }
            if (!this.isRunning()) {
                return;
            }
            this.tickRecipe();
            if (this.consumedUnits >= this.recipe.getNumTicks()) {
                IFluidHandler iFluidHandler;
                FluidStack fluidStack;
                Optional<IFluidHandler> hdlr;
                this.consumedUnits = 0;
                this.setChanged();
                List<ItemStack> items = this.createItemIngredients(this.recipe, this.formedSetup);
                List<FluidStack> fluids = this.createFluidIngredients(this.recipe, this.formedSetup);
                if (this.hasItemIngredients(items, this.formedSetup) && this.hasFluidIngredients(fluids, this.formedSetup) && (hdlr = this.formedSetup.getCellFluidHandler()).isPresent() && (fluidStack = (iFluidHandler = hdlr.orElseThrow(NullPointerException::new)).drain(this.recipe.getNumUnits(), IFluidHandler.FluidAction.SIMULATE)).getAmount() == this.recipe.getNumUnits()) {
                    this.consumeItemIngredients(items, this.formedSetup);
                    this.consumeFluidIngredients(fluids, this.formedSetup);
                    iFluidHandler.drain(this.recipe.getNumUnits(), IFluidHandler.FluidAction.EXECUTE);
                    LootGeneration.get().generate(this, this.formedSetup);
                }
            }
        }
    }

    private List<ItemStack> createItemIngredients(HeartRecipe recipe, FormedSetup formedSetup) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (ItemStack itemStack : recipe.recipeItems()) {
            items.add(itemStack.copy());
        }
        return items;
    }

    private List<FluidStack> createFluidIngredients(HeartRecipe recipe, FormedSetup formedSetup) {
        ArrayList<FluidStack> fluids = new ArrayList<FluidStack>();
        for (FluidStack fluidStack : recipe.recipeFluids()) {
            fluids.add(fluidStack.copy());
        }
        return fluids;
    }

    private boolean hasItemIngredients(List<ItemStack> items, FormedSetup formedSetup) {
        if (items.isEmpty()) {
            return true;
        }
        for (ItemStack itemStack : items) {
            int count = StorageHelper.getCount(itemStack, formedSetup.getImportHandlers());
            if (count != 0 && count >= itemStack.getCount()) continue;
            return false;
        }
        return true;
    }

    private boolean hasFluidIngredients(List<FluidStack> fluids, FormedSetup formedSetup) {
        if (fluids.isEmpty()) {
            return true;
        }
        for (FluidStack fluidStack : fluids) {
            int amount = StorageHelper.getAmount(fluidStack, formedSetup.getImportFluidHandlers());
            if (amount != 0 && amount >= fluidStack.getAmount()) continue;
            return false;
        }
        return true;
    }

    private void consumeItemIngredients(List<ItemStack> items, FormedSetup formedSetup) {
        if (items.isEmpty()) {
            return;
        }
        for (Optional<IItemHandler> hdlr : formedSetup.getImportHandlers()) {
            if (items.isEmpty()) break;
            hdlr.ifPresent(h -> {
                for (ItemStack itemStack : items) {
                    if (itemStack.isEmpty()) continue;
                    Woot.setup.getLogger().debug("consumeItemIngredients: to consume {}", (Object)itemStack);
                    for (int slot = 0; slot < h.getSlots(); ++slot) {
                        ItemStack slotStack = h.getStackInSlot(slot);
                        if (slotStack.isEmpty() || !ItemStack.isSameItem((ItemStack)itemStack, (ItemStack)slotStack)) continue;
                        Woot.setup.getLogger().debug("consumeItemIngredients: slot {} consume {}", (Object)slot, (Object)itemStack.getCount());
                        ItemStack extractedStack = h.extractItem(slot, itemStack.getCount(), false);
                        if (extractedStack.isEmpty()) continue;
                        itemStack.shrink(extractedStack.getCount());
                    }
                }
            });
        }
    }

    private void consumeFluidIngredients(List<FluidStack> fluids, FormedSetup formedSetup) {
        if (fluids.isEmpty()) {
            return;
        }
        for (Optional<IFluidHandler> hdlr : formedSetup.getImportFluidHandlers()) {
            if (fluids.isEmpty()) break;
            hdlr.ifPresent(h -> {
                for (FluidStack fluidStack : fluids) {
                    if (fluidStack.isEmpty()) continue;
                    Woot.setup.getLogger().debug("consumeFluidIngredients: to consume {}", (Object)fluidStack);
                    FluidStack drainedStack = h.drain(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                    int consumed = drainedStack.getAmount();
                    fluidStack.setAmount(fluidStack.getAmount() - consumed);
                    if (fluidStack.getAmount() < 0) {
                        fluidStack.setAmount(0);
                    }
                    Woot.setup.getLogger().debug("consumeFluidIngredients: consumed {}", (Object)consumed);
                }
            });
        }
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("Progress")) {
            this.loadedFromNBT = true;
            this.consumedUnits = tag.getInt("Progress");
            LOGGER.debug("read: loading progress " + this.consumedUnits);
        }
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.isFormed() && this.recipe != null) {
            tag.putInt("Progress", this.consumedUnits);
            LOGGER.debug("write: saving progress " + this.consumedUnits);
        }
    }

    public boolean couldFinish() {
        if (!this.isRunning() || !this.isFormed()) {
            return false;
        }
        return this.formedSetup.getCellFluidAmount() >= this.recipe.getNumUnits();
    }

    public boolean hasFlayedPerk() {
        if (!this.isFormed()) {
            return false;
        }
        return this.formedSetup.getAllPerks().containsKey((Object)Perk.Group.flayed);
    }

    @Override
    public void interrupt() {
        if (this.layout != null) {
            this.layout.setDirty();
        }
    }

    void tickRecipe() {
        this.consumedUnits += 5;
        this.setChanged();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new HeartMenu(i, inventory, this);
    }

    @Override
    public List<String> getDebugText(List<String> debug, UseOnContext itemUseContext) {
        debug.add("====> HeartTileEntity");
        debug.add("      layout: " + String.valueOf(this.layout));
        debug.add("      setup: " + String.valueOf(this.formedSetup));
        debug.add("      recipe: " + String.valueOf(this.recipe));
        debug.add("      consumed: " + this.consumedUnits);
        return debug;
    }

    public Component getDisplayName() {
        if (this.isFormed()) {
            return Component.translatable((String)this.formedSetup.getTier().getTranslationKey());
        }
        return Component.literal((String)this.getType().builtInRegistryHolder().getRegisteredName());
    }

    public int getFluidCapacity() {
        return this.formedSetup != null ? this.formedSetup.getCellCapacity() : 0;
    }

    public int getCellType() {
        return this.formedSetup != null ? this.formedSetup.getCellType() : 0;
    }

    public FluidStack getTankFluid() {
        return this.formedSetup != null ? new FluidStack((Fluid)FluidSetup.CONATUS_FLUID.get(), this.formedSetup.getCellFluidAmount()) : FluidStack.EMPTY;
    }

    public int getProgress() {
        if (this.formedSetup == null) {
            return 0;
        }
        return (int)(100.0f / (float)this.recipe.getNumTicks() * (float)this.consumedUnits);
    }

    public List<FakeMob> getFormedMobs() {
        ArrayList<FakeMob> mobs = new ArrayList<FakeMob>();
        if (this.isFormed()) {
            mobs.addAll(this.formedSetup.getAllMobs());
        }
        return mobs;
    }

    public Map<Perk.Group, Integer> getPerks() {
        HashMap<Perk.Group, Integer> perks = new HashMap<Perk.Group, Integer>();
        if (this.isFormed()) {
            perks.putAll(this.formedSetup.getAllPerks());
        }
        return perks;
    }

    @javax.annotation.Nullable
    public FormedSetup getFormedSetup() {
        return this.formedSetup;
    }

    public Tier getTier() {
        return this.isFormed() ? this.formedSetup.getTier() : Tier.UNKNOWN;
    }

    public Exotic getExotic() {
        return this.isFormed() ? this.formedSetup.getExotic() : Exotic.NONE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setClientFactorySetup(ClientFactorySetup clientFactorySetup) {
        this.clientFactorySetup = clientFactorySetup;
    }

    public HeartStaticDataReply createStaticDataReply2() {
        return new HeartStaticDataReply(this.formedSetup, this.recipe);
    }

    public class TickTracker {
        long lastGameTime = -1L;
        int structureTicksTimeout = 0;
        int currStructureTicks = 0;

        public TickTracker(HeartBlockEntity this$0) {
        }

        public boolean tick(Level world) {
            boolean realTick = false;
            long currGameTime = world.getGameTime();
            if (((Boolean)FactoryConfiguration.TICK_ACCEL.get()).booleanValue() || this.lastGameTime != currGameTime) {
                this.lastGameTime = currGameTime;
                realTick = true;
                if (this.structureTicksTimeout > 0) {
                    ++this.currStructureTicks;
                }
            }
            return realTick;
        }

        public boolean hasStructureTickExpired() {
            return this.structureTicksTimeout > 0 && this.currStructureTicks >= this.structureTicksTimeout;
        }

        public void setStructureTickCount(int ticks) {
            this.structureTicksTimeout = ticks;
        }

        public void resetStructureTickCount() {
            this.currStructureTicks = 0;
        }
    }
}

