/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.factory.blocks;

import ipsis.woot.fluilds.network.TankPacket;
import ipsis.woot.modules.factory.FactorySetup;
import ipsis.woot.modules.factory.blocks.HeartBlockEntity;
import ipsis.woot.modules.factory.client.ClientFactorySetup;
import ipsis.woot.util.TankPacketHandler;
import ipsis.woot.util.WootContainer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class HeartMenu
extends WootContainer
implements TankPacketHandler {
    private HeartBlockEntity tileEntity;
    private Inventory pInventory;
    private int progress = 0;
    private FluidStack inputFluid = FluidStack.EMPTY;
    private int cellType = 0;

    public HeartMenu(int containerId, Inventory inv, FriendlyByteBuf extraData) {
        this(containerId, inv, inv.player.level().getBlockEntity(extraData.readBlockPos()));
    }

    public HeartMenu(int windowId, Inventory playerInventory, BlockEntity entity) {
        super((MenuType)FactorySetup.HEART_BLOCK_CONTAINER.get(), windowId);
        this.tileEntity = (HeartBlockEntity)entity;
        this.pInventory = playerInventory;
        this.addListeners();
    }

    public BlockPos getPos() {
        return this.tileEntity.getBlockPos();
    }

    @Override
    public boolean stillValid(Player playerIn) {
        return HeartMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.tileEntity.getLevel(), (BlockPos)this.tileEntity.getBlockPos()), (Player)playerIn, (Block)((Block)FactorySetup.HEART_BLOCK.get()));
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        if (this.tileEntity.getLevel().isClientSide) {
            return;
        }
        if (!this.inputFluid.is(this.tileEntity.getTankFluid().getFluid()) || this.inputFluid.getAmount() != this.tileEntity.getTankFluid().getAmount()) {
            this.inputFluid = this.tileEntity.getTankFluid().copy();
            TankPacket tankPacket = new TankPacket(this.inputFluid, 0);
            Player player = this.pInventory.player;
            if (player instanceof ServerPlayer) {
                ServerPlayer pl = (ServerPlayer)player;
                PacketDistributor.sendToPlayer((ServerPlayer)pl, (CustomPacketPayload)tankPacket, (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public FluidStack getInputFluid() {
        return this.inputFluid;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getProgress() {
        return this.progress;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getCellType() {
        return this.cellType;
    }

    private void addListeners() {
        this.addDataSlot(new DataSlot(){

            public int get() {
                return HeartMenu.this.tileEntity.getProgress();
            }

            public void set(int i) {
                HeartMenu.this.progress = i;
            }
        });
        this.addDataSlot(new DataSlot(){

            public int get() {
                return HeartMenu.this.tileEntity.getCellType();
            }

            public void set(int i) {
                HeartMenu.this.cellType = i;
            }
        });
    }

    public HeartBlockEntity getTileEntity() {
        return this.tileEntity;
    }

    public void handleStaticDataReply(ClientFactorySetup clientFactorySetup) {
        this.tileEntity.setClientFactorySetup(clientFactorySetup);
    }

    @Override
    public void handlePacket(TankPacket packet) {
        if (packet.tankId() == 0) {
            this.inputFluid = packet.fluidStack();
        }
    }
}

