/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.factory.blocks;

import ipsis.woot.util.ExtraWootCodecs;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;

public record HeartRecipe(int numTicks, int numUnits, List<ItemStack> recipeItems, List<FluidStack> recipeFluids) {
    public static final StreamCodec<RegistryFriendlyByteBuf, HeartRecipe> STREAM_CODEC = StreamCodec.of((buf, recipe) -> {
        buf.writeVarInt(recipe.numTicks);
        buf.writeVarInt(recipe.numUnits);
        buf.writeVarInt(recipe.recipeItems.size());
        if (!recipe.recipeItems.isEmpty()) {
            ExtraWootCodecs.ITEM_LIST_CODEC.encode(buf, recipe.recipeItems);
        }
        buf.writeVarInt(recipe.recipeFluids.size());
        if (!recipe.recipeFluids.isEmpty()) {
            ExtraWootCodecs.FLUID_LIST_CODEC.encode(buf, recipe.recipeFluids);
        }
    }, buf -> {
        int numTicks = buf.readVarInt();
        int numUnits = buf.readVarInt();
        int size = buf.readVarInt();
        ArrayList<ItemStack> items = size > 0 ? (List)ExtraWootCodecs.ITEM_LIST_CODEC.decode(buf) : new ArrayList();
        size = buf.readVarInt();
        ArrayList<FluidStack> fluids = size > 0 ? (List)ExtraWootCodecs.FLUID_LIST_CODEC.decode(buf) : new ArrayList();
        return new HeartRecipe(numTicks, numUnits, items, fluids);
    });

    public int getNumTicks() {
        return this.numTicks;
    }

    public int getNumUnits() {
        return this.numUnits;
    }

    public void addItem(ItemStack itemStack) {
        boolean added = false;
        for (ItemStack currStack : this.recipeItems) {
            if (!currStack.is(itemStack.getItem())) continue;
            currStack.setCount(currStack.getCount() + itemStack.getCount());
            added = true;
        }
        if (!added) {
            ItemStack addStack = itemStack.copy();
            this.recipeItems.add(addStack);
        }
    }

    public void addFluid(FluidStack fluidStack) {
        boolean added = false;
        for (FluidStack currStack : this.recipeFluids) {
            if (!currStack.is(fluidStack.getFluid())) continue;
            currStack.setAmount(currStack.getAmount() + fluidStack.getAmount());
            added = true;
        }
        if (!added) {
            FluidStack addStack = fluidStack.copy();
            this.recipeFluids.add(addStack);
        }
    }

    @Override
    public String toString() {
        return "Recipe{numTicks=" + this.numTicks + ", numUnits=" + this.numUnits + ", items=" + this.recipeItems.size() + ", fluids=" + this.recipeFluids.size() + "}";
    }
}

