/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.factory.blocks;

import ipsis.woot.modules.factory.FactoryComponent;
import ipsis.woot.modules.factory.blocks.FactoryBlock;
import ipsis.woot.modules.factory.blocks.UpgradeBlockEntity;
import ipsis.woot.modules.factory.items.PerkItem;
import ipsis.woot.modules.factory.perks.Perk;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class UpgradeBlock
extends FactoryBlock {
    public static final EnumProperty<Perk> UPGRADE = EnumProperty.create((String)"upgrade", Perk.class, (Enum[])Perk.values());

    public UpgradeBlock(FactoryComponent component) {
        super(component);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue(UPGRADE, (Comparable)((Object)Perk.empty))).setValue((Property)BlockStateProperties.ATTACHED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{UPGRADE, BlockStateProperties.ATTACHED});
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        Item item;
        if (!level.isClientSide && !stack.isEmpty() && (item = stack.getItem()) instanceof PerkItem) {
            PerkItem perkItem = (PerkItem)item;
            BlockEntity te = level.getBlockEntity(pos);
            if (te instanceof UpgradeBlockEntity && ((UpgradeBlockEntity)te).tryAddUpgrade(level, player, state, perkItem.getFactoryUpgrade()) && !player.isCreative()) {
                stack.shrink(1);
            }
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity te = level.getBlockEntity(pos);
            if (te instanceof UpgradeBlockEntity) {
                ((UpgradeBlockEntity)te).dropItems(state, level, pos);
            }
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new UpgradeBlockEntity(pos, state);
    }
}

