/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.factory.blocks;

import ipsis.woot.Woot;
import ipsis.woot.modules.factory.FactorySetup;
import ipsis.woot.modules.factory.blocks.UpgradeBlock;
import ipsis.woot.modules.factory.items.PerkItem;
import ipsis.woot.modules.factory.multiblock.MultiBlockBlockEntity;
import ipsis.woot.modules.factory.multiblock.MultiBlockTracker;
import ipsis.woot.modules.factory.perks.Perk;
import ipsis.woot.util.WootDebug;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class UpgradeBlockEntity
extends MultiBlockBlockEntity
implements WootDebug {
    public UpgradeBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FactorySetup.FACTORY_UPGRADE_BLOCK_ENTITY.get(), pos, state);
    }

    public boolean tryAddUpgrade(Level world, Player playerEntity, BlockState state, Perk type) {
        if (state.getValue(UpgradeBlock.UPGRADE) == Perk.empty) {
            if (Perk.LEVEL_1_PERKS.contains((Object)type)) {
                world.setBlock(this.getBlockPos(), (BlockState)state.setValue(UpgradeBlock.UPGRADE, (Comparable)((Object)type)), 2);
                this.glue.onGoodbye();
                MultiBlockTracker.get().addEntry(world, this.getBlockPos());
                Woot.setup.getLogger().debug("tryAddUpgrade: added {}", (Object)type);
                return true;
            }
            playerEntity.sendSystemMessage((Component)Component.translatable((String)"chat.woot.perk.fail.0"));
            return false;
        }
        Perk upgrade = (Perk)((Object)this.getBlockState().getValue(UpgradeBlock.UPGRADE));
        Perk.Group currType = Perk.getGroup(upgrade);
        Perk.Group addType = Perk.getGroup(type);
        int currLevel = Perk.getLevel(upgrade);
        int addLevel = Perk.getLevel(type);
        if (currType != addType) {
            playerEntity.sendSystemMessage((Component)Component.translatable((String)"chat.woot.perk.fail.1"));
            return false;
        }
        if (currLevel == 3) {
            playerEntity.sendSystemMessage((Component)Component.translatable((String)"chat.woot.perk.fail.2"));
            return false;
        }
        if (currLevel == addLevel) {
            playerEntity.sendSystemMessage((Component)Component.translatable((String)"chat.woot.perk.fail.4"));
            return false;
        }
        if (currLevel + 1 != addLevel) {
            playerEntity.sendSystemMessage((Component)Component.translatable((String)"chat.woot.perk.fail.4", (Object[])new Object[]{currLevel + 1}));
            return false;
        }
        world.setBlock(this.getBlockPos(), (BlockState)state.setValue(UpgradeBlock.UPGRADE, (Comparable)((Object)type)), 2);
        this.glue.onGoodbye();
        MultiBlockTracker.get().addEntry(world, this.getBlockPos());
        Woot.setup.getLogger().debug("tryAddUpgrade: added {}", (Object)type);
        return true;
    }

    public void dropItems(BlockState state, Level world, BlockPos pos) {
        Perk upgrade = (Perk)((Object)state.getValue(UpgradeBlock.UPGRADE));
        if (upgrade == Perk.empty) {
            return;
        }
        int currLevel = Perk.getLevel(upgrade);
        for (int i = 1; i <= 3; ++i) {
            Perk.Group type;
            ItemStack itemStack;
            if (i > currLevel || (itemStack = PerkItem.getItemStack(type = Perk.getGroup(upgrade), i)).isEmpty()) continue;
            itemStack.setCount(1);
            Containers.dropItemStack((Level)world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)itemStack);
        }
    }

    @Nullable
    public Perk getUpgrade(BlockState state) {
        return (Perk)((Object)state.getValue(UpgradeBlock.UPGRADE));
    }

    @Override
    public List<String> getDebugText(List<String> debug, UseOnContext itemUseContext) {
        debug.add("====> UpgradeTileEntity");
        debug.add("      hasMaster: " + this.glue.hasMaster());
        debug.add("      upgrade: " + String.valueOf(this.level.getBlockState(this.getBlockPos()).getValue(UpgradeBlock.UPGRADE)));
        return debug;
    }
}

