/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.factory.calculators;

import ipsis.woot.Woot;
import ipsis.woot.crafting.WootRecipes;
import ipsis.woot.crafting.factory.FactoryRecipe;
import ipsis.woot.modules.factory.FactoryConfiguration;
import ipsis.woot.modules.factory.FormedSetup;
import ipsis.woot.modules.factory.blocks.HeartRecipe;
import ipsis.woot.modules.factory.perks.Perk;
import ipsis.woot.util.FakeMob;
import ipsis.woot.util.FluidStackHelper;
import ipsis.woot.util.ItemStackHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.fluids.FluidStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CalculatorVersion2 {
    private static final Logger LOGGER = LogManager.getLogger();

    private static double getEfficiency(FakeMob fakeMob, FormedSetup setup) {
        double v = 0.0;
        if (setup.hasConatusExotic()) {
            v = (Double)FactoryConfiguration.EXOTIC_C.get();
            LOGGER.debug("Calculator: EXOTIC {} conatus efficiency", (Object)v);
        } else if (setup.getAllPerks().containsKey((Object)Perk.Group.efficiency)) {
            v = setup.getAllMobParams().get(fakeMob).getPerkEfficiencyValue();
            LOGGER.debug("Calculator: PERK {} conatus efficiency", (Object)v);
        }
        return v;
    }

    private static int calcConatus(FormedSetup setup) {
        int fluidCost = 0;
        for (FakeMob fakeMob : setup.getAllMobs()) {
            int mobCost = setup.getAllMobParams().get((Object)fakeMob).baseFluidCost * setup.getAllMobParams().get(fakeMob).getMobCount(setup.getAllPerks().containsKey((Object)Perk.Group.mass), setup.hasMassExotic());
            LOGGER.debug("Calculator mob:{} fluidCost:{}", (Object)fakeMob, (Object)mobCost);
            int fluidSaving = (int)((double)((float)mobCost / 100.0f) * CalculatorVersion2.getEfficiency(fakeMob, setup));
            mobCost -= fluidSaving;
            mobCost = Math.clamp((long)mobCost, 0, Integer.MAX_VALUE);
            LOGGER.debug("Calculator: {} saving of {}mB -> {}mB", (Object)fakeMob, (Object)fluidSaving, (Object)mobCost);
            fluidCost += mobCost;
        }
        return fluidCost;
    }

    private static int calcSpawnTick(int actualSpawnTicks, int baseSpawnTicks, FormedSetup setup) {
        int ticks = actualSpawnTicks;
        if (setup.hasSpawnTimExotic()) {
            ticks = (Integer)FactoryConfiguration.EXOTIC_D.get();
            LOGGER.debug("Calculator: EXOTIC {} ticks", (Object)ticks);
        } else {
            int rateSaving = (int)((float)baseSpawnTicks / 100.0f * (float)setup.getMinRateValue());
            LOGGER.debug("Calculator: PERK {} rate", (Object)rateSaving);
            ticks -= rateSaving;
            LOGGER.debug("Calculator: {} @ {}% -> {}", (Object)baseSpawnTicks, (Object)setup.getMinRateValue(), (Object)actualSpawnTicks);
        }
        return ticks;
    }

    public static List<ItemStack> getRecipeItems(FakeMob fakeMob, List<ItemStack> recipeItems, FormedSetup setup) {
        int mobCount = setup.getAllMobParams().get(fakeMob).getMobCount(setup.getAllPerks().containsKey((Object)Perk.Group.mass), setup.hasMassExotic());
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (setup.hasItemIngredientExotic()) {
            for (ItemStack itemStack : recipeItems) {
                itemStack1 = itemStack.copy();
                itemStack1.setCount(itemStack1.getCount() * mobCount);
                if ((itemStack1 = ItemStackHelper.reduceByPercentage(itemStack1, (Double)FactoryConfiguration.EXOTIC_B.get())).isEmpty()) continue;
                items.add(itemStack1);
            }
        } else {
            for (ItemStack itemStack : recipeItems) {
                if (itemStack.isEmpty()) continue;
                Woot.setup.getLogger().debug("getRecipeItems: {} {} {} {}", (Object)fakeMob, (Object)itemStack.getDescriptionId(), (Object)itemStack.getCount(), (Object)mobCount);
                itemStack1 = itemStack.copy();
                itemStack1.setCount(itemStack1.getCount() * mobCount);
                items.add(itemStack1);
            }
        }
        for (ItemStack itemStack : items) {
            Woot.setup.getLogger().debug("getRecipeItems: {} ", (Object)itemStack);
        }
        return items;
    }

    public static List<FluidStack> getRecipeFluids(FakeMob fakeMob, List<FluidStack> recipeFluids, FormedSetup setup) {
        int mobCount = setup.getAllMobParams().get(fakeMob).getMobCount(setup.getAllPerks().containsKey((Object)Perk.Group.mass), setup.hasMassExotic());
        ArrayList<FluidStack> fluids = new ArrayList<FluidStack>();
        if (setup.hasFluidIngredientExotic()) {
            for (FluidStack fluidStack : recipeFluids) {
                fluidStack1 = fluidStack.copy();
                fluidStack1.setAmount(fluidStack1.getAmount() * mobCount);
                if ((fluidStack1 = FluidStackHelper.reduceByPercentage(fluidStack1, (Double)FactoryConfiguration.EXOTIC_A.get())).isEmpty()) continue;
                fluids.add(fluidStack1);
            }
        } else {
            for (FluidStack fluidStack : recipeFluids) {
                if (fluidStack.isEmpty()) continue;
                Woot.setup.getLogger().debug("getRecipeFluids: {} {} {} {}", (Object)fakeMob, (Object)fluidStack.getDescriptionId(), (Object)fluidStack.getAmount(), (Object)mobCount);
                fluidStack1 = fluidStack.copy();
                fluidStack1.setAmount(fluidStack1.getAmount() * mobCount);
                fluids.add(fluidStack1);
            }
        }
        for (FluidStack fluidStack : fluids) {
            Woot.setup.getLogger().debug("getRecipeItems: {} ", (Object)fluidStack);
        }
        return fluids;
    }

    public static HeartRecipe calculate(FormedSetup setup) {
        int baseSpawnTicks;
        for (FakeMob fakeMob : setup.getAllMobs()) {
            LOGGER.debug("Calulator mob:{} params:{}", (Object)fakeMob, (Object)setup.getAllMobParams().get(fakeMob));
        }
        int fluidCost = CalculatorVersion2.calcConatus(setup);
        LOGGER.debug("Calculator fluidCost:{}", (Object)fluidCost);
        int actualSpawnTicks = baseSpawnTicks = setup.getMaxSpawnTime();
        LOGGER.debug("Calculator baseSpawnTicks:{} actualSpawnTick:{}", (Object)baseSpawnTicks, (Object)actualSpawnTicks);
        actualSpawnTicks = CalculatorVersion2.calcSpawnTick(actualSpawnTicks, baseSpawnTicks, setup);
        LOGGER.debug("Calculator actualSpawnTick:{}", (Object)actualSpawnTicks);
        HeartRecipe recipe = new HeartRecipe(Math.clamp((long)actualSpawnTicks, 1, Integer.MAX_VALUE), Math.clamp((long)fluidCost, 1, Integer.MAX_VALUE), new ArrayList<ItemStack>(), new ArrayList<FluidStack>());
        for (FakeMob fakeMob : setup.getAllMobs()) {
            FactoryRecipe factoryRecipe = CalculatorVersion2.getRecipeForMob(setup.getWorld().getRecipeManager(), fakeMob);
            if (factoryRecipe == null) continue;
            List<ItemStack> recipeItems = CalculatorVersion2.getRecipeItems(fakeMob, factoryRecipe.getItems(), setup);
            List<FluidStack> recipeFluids = CalculatorVersion2.getRecipeFluids(fakeMob, factoryRecipe.getFluids(), setup);
            recipeItems.forEach(i -> recipe.addItem(i.copy()));
            recipeFluids.forEach(i -> recipe.addFluid(i.copy()));
        }
        return recipe;
    }

    public static FactoryRecipe getRecipeForMob(RecipeManager recipeManager, FakeMob mob) {
        List recipes = recipeManager.getAllRecipesFor((RecipeType)WootRecipes.FACTORY_RECIPE_TYPE.get());
        for (RecipeHolder recipe : recipes) {
            if (!((FactoryRecipe)recipe.value()).fakeMob().equals(mob)) continue;
            return (FactoryRecipe)recipe.value();
        }
        return null;
    }
}

