/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.factory.client;

import ipsis.woot.modules.factory.Exotic;
import ipsis.woot.modules.factory.MobParam;
import ipsis.woot.modules.factory.Tier;
import ipsis.woot.modules.factory.perks.Perk;
import ipsis.woot.simulator.SimulatedMobDropSummary;
import ipsis.woot.util.ExtraWootCodecs;
import ipsis.woot.util.FakeMob;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.codec.StreamDecoder;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;

public class ClientFactorySetup {
    public Tier tier = Tier.TIER_1;
    public List<FakeMob> controllerMobs = new ArrayList<FakeMob>();
    public List<Perk> perks = new ArrayList<Perk>();
    public HashMap<FakeMob, MobParam> mobParams = new HashMap();
    public HashMap<FakeMob, Mob> mobInfo = new HashMap();
    public Exotic exotic = Exotic.NONE;
    public int cellCapacity = 0;
    public int looting = 0;
    public int recipeTicks = 0;
    public int recipeFluid = 0;
    public boolean perkCapped = false;
    public int shardRolls = 1;
    public double shardDropChance = 0.0;
    public double[] shardDrops = new double[]{0.0, 0.0, 0.0};
    public List<ItemStack> itemIng = new ArrayList<ItemStack>();
    public List<FluidStack> fluidIng = new ArrayList<FluidStack>();
    public static final StreamCodec<RegistryFriendlyByteBuf, HashMap<FakeMob, Mob>> MAP_CODEC = ExtraWootCodecs.mapStreamCodec(FakeMob.STREAM_CODEC, Mob.STREAM_CODEC, HashMap::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, HashMap<FakeMob, MobParam>> PARAM_MAP_CODEC = ExtraWootCodecs.mapStreamCodec(FakeMob.STREAM_CODEC, MobParam.STREAM_CODEC, HashMap::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, List<FakeMob>> MOB_LIST_CODEC = ExtraWootCodecs.listStreamCodec(FakeMob.STREAM_CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientFactorySetup> STREAM_CODEC = StreamCodec.of((buf, data) -> {
        buf.writeInt(data.tier.ordinal());
        buf.writeInt(data.cellCapacity);
        buf.writeInt(data.looting);
        buf.writeInt(data.exotic.ordinal());
        buf.writeInt(data.recipeTicks);
        buf.writeInt(data.recipeFluid);
        buf.writeInt(data.shardRolls);
        buf.writeDouble(data.shardDropChance);
        buf.writeArray((Object[])((Double[])Arrays.stream(data.shardDrops).boxed().toArray(Double[]::new)), (StreamEncoder)ByteBufCodecs.DOUBLE);
        PARAM_MAP_CODEC.encode(buf, data.mobParams);
        MAP_CODEC.encode(buf, data.mobInfo);
        buf.writeBoolean(data.perkCapped);
        buf.writeVarInt(data.perks.size());
        data.perks.forEach(p -> buf.writeVarInt(p.ordinal()));
        ExtraWootCodecs.ITEM_LIST_CODEC.encode(buf, data.itemIng);
        ExtraWootCodecs.FLUID_LIST_CODEC.encode(buf, data.fluidIng);
    }, buf -> {
        ClientFactorySetup factorySetup = new ClientFactorySetup();
        factorySetup.tier = Tier.byIndex(buf.readInt());
        factorySetup.cellCapacity = buf.readInt();
        factorySetup.looting = buf.readInt();
        factorySetup.exotic = Exotic.getExotic(buf.readInt());
        factorySetup.recipeTicks = buf.readInt();
        factorySetup.recipeFluid = buf.readInt();
        factorySetup.shardRolls = buf.readInt();
        factorySetup.shardDropChance = buf.readDouble();
        factorySetup.shardDrops = Arrays.stream((Double[])buf.readArray(Double[]::new, (StreamDecoder)ByteBufCodecs.DOUBLE)).mapToDouble(Double::doubleValue).toArray();
        factorySetup.mobParams = (HashMap)PARAM_MAP_CODEC.decode(buf);
        factorySetup.mobInfo = (HashMap)MAP_CODEC.decode(buf);
        factorySetup.controllerMobs = factorySetup.mobParams.keySet().stream().toList();
        factorySetup.perkCapped = buf.readBoolean();
        int size = buf.readVarInt();
        for (int i = 0; i < size; ++i) {
            factorySetup.perks.add(Perk.byIndex(buf.readVarInt()));
        }
        factorySetup.itemIng = (List)ExtraWootCodecs.ITEM_LIST_CODEC.decode(buf);
        factorySetup.fluidIng = (List)ExtraWootCodecs.FLUID_LIST_CODEC.decode(buf);
        return factorySetup;
    });

    public record Mob(List<SimulatedMobDropSummary> drops) {
        public static final StreamCodec<RegistryFriendlyByteBuf, Mob> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.collection(ArrayList::new, SimulatedMobDropSummary.STREAM_CODEC), Mob::drops, Mob::new);

        public Mob() {
            this(new ArrayList<SimulatedMobDropSummary>());
        }
    }
}

