/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.factory.client;

import ipsis.woot.fluilds.FluidSetup;
import ipsis.woot.modules.factory.Exotic;
import ipsis.woot.modules.factory.FactoryConfiguration;
import ipsis.woot.modules.factory.MobParam;
import ipsis.woot.modules.factory.Tier;
import ipsis.woot.modules.factory.blocks.ControllerBlockEntity;
import ipsis.woot.modules.factory.blocks.HeartMenu;
import ipsis.woot.modules.factory.client.ClientFactorySetup;
import ipsis.woot.modules.factory.items.PerkItem;
import ipsis.woot.modules.factory.perks.Perk;
import ipsis.woot.setup.ServerDataRequest;
import ipsis.woot.simulator.SimulatedMobDropSummary;
import ipsis.woot.util.FakeMob;
import ipsis.woot.util.WootContainerScreen;
import ipsis.woot.util.helper.RenderHelper;
import ipsis.woot.util.helper.StringHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.network.PacketDistributor;

@OnlyIn(value=Dist.CLIENT)
public class HeartScreen
extends WootContainerScreen<HeartMenu> {
    private ResourceLocation GUI = ResourceLocation.fromNamespaceAndPath((String)"woot", (String)"textures/gui/heart.png");
    private List<GuiItemStackElement> dropElements = new ArrayList<GuiItemStackElement>();
    private List<GuiItemStackElement> mobElements = new ArrayList<GuiItemStackElement>();
    private List<GuiItemStackElement> upgradeElements = new ArrayList<GuiItemStackElement>();
    private List<GuiStackElement> recipeElements = new ArrayList<GuiStackElement>();
    private int GUI_WIDTH = 252;
    private int GUI_HEIGHT = 222;
    private int DROPS_COLS = 13;
    private int DROPS_ROWS = 4;
    private int DROPS_X = 10;
    private int DROPS_Y = 144;
    private int MOBS_X = 10;
    private int MOBS_Y = 76;
    private int PERKS_X = 99;
    private int PERKS_Y = 76;
    private int RECIPE_X = 10;
    private int RECIPE_Y = 110;
    private float DROP_CYCLE_MS = 5000.0f;
    private int TEXT_COLOR = 0x404040;
    private static final int TANK_LX = 226;
    private static final int TANK_LY = 8;
    private static final int TANK_RX = 241;
    private static final int TANK_RY = 91;
    private static int EXOTIC_X = 190;
    private static int EXOTIC_Y = 76;
    private StackElement exoticElement = new StackElement(EXOTIC_X, EXOTIC_Y);
    private long renderTime;
    private int currFluidRender;
    private boolean sync = false;

    public HeartScreen(HeartMenu menu, Inventory pInventory, Component name) {
        super(menu, pInventory, name);
        this.imageHeight = this.GUI_HEIGHT;
        this.imageWidth = this.GUI_WIDTH;
        this.font = Minecraft.getInstance().font;
        this.currFluidRender = menu.getInputFluid().getAmount();
    }

    protected void init() {
        int i;
        super.init();
        for (i = 0; i < 4; ++i) {
            this.mobElements.add(new GuiItemStackElement(this.MOBS_X + i * 18, this.MOBS_Y, true));
        }
        for (i = 0; i < 4; ++i) {
            this.upgradeElements.add(new GuiItemStackElement(this.PERKS_X + i * 18, this.PERKS_Y, true));
        }
        for (int row = 0; row < this.DROPS_ROWS; ++row) {
            for (int col = 0; col < this.DROPS_COLS; ++col) {
                this.dropElements.add(new GuiItemStackElement(this.DROPS_X + col * 18, this.DROPS_Y + row * 18));
            }
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new ServerDataRequest("", ((HeartMenu)this.menu).getPos(), ServerDataRequest.Type.HEART_STATIC_DATA.ordinal()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private int getCapacity() {
        int capacity = 0;
        HeartMenu heartMenu = (HeartMenu)this.menu;
        if (heartMenu.getCellType() == 0) {
            capacity = (Integer)FactoryConfiguration.CELL_1_CAPACITY.get();
        } else if (heartMenu.getCellType() == 1) {
            capacity = (Integer)FactoryConfiguration.CELL_2_CAPACITY.get();
        } else if (heartMenu.getCellType() == 2) {
            capacity = (Integer)FactoryConfiguration.CELL_3_CAPACITY.get();
        } else if (heartMenu.getCellType() == 3) {
            capacity = (Integer)FactoryConfiguration.CELL_4_CAPACITY.get();
        }
        return capacity;
    }

    public void attemptRenderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (mouseX > this.getGuiLeft() + EXOTIC_X && mouseX < this.getGuiLeft() + EXOTIC_X + 18 && mouseY > this.getGuiTop() + EXOTIC_Y && mouseY < this.getGuiTop() + EXOTIC_Y + 18) {
            this.exoticElement.drawTooltip(guiGraphics, mouseX, mouseY);
        }
        if (mouseX > this.getGuiLeft() + this.MOBS_X && mouseX < this.getGuiLeft() + this.MOBS_X + 18 * this.mobElements.size() && mouseY > this.getGuiTop() + this.MOBS_Y && mouseY < this.getGuiTop() + this.MOBS_Y + 18 * this.mobElements.size()) {
            this.mobElements.get((mouseX - (this.getGuiLeft() + this.MOBS_X)) / 18).drawTooltip(guiGraphics, mouseX, mouseY);
        }
        if (mouseX > this.getGuiLeft() + this.RECIPE_X && mouseX < this.getGuiLeft() + this.RECIPE_X + 18 * this.recipeElements.size() && mouseY > this.getGuiTop() + this.RECIPE_Y && mouseY < this.getGuiTop() + this.RECIPE_Y + 18) {
            this.recipeElements.get((mouseX - (this.getGuiLeft() + this.RECIPE_X)) / 18).drawTooltip(guiGraphics, mouseX, mouseY);
        }
        if (mouseX > this.getGuiLeft() + this.PERKS_X && mouseX < this.getGuiLeft() + this.PERKS_X + 18 * this.upgradeElements.size() && mouseY > this.getGuiTop() + this.PERKS_Y && mouseY < this.getGuiTop() + this.PERKS_Y + 18 * this.upgradeElements.size()) {
            this.upgradeElements.get((mouseX - (this.getGuiLeft() + this.PERKS_X)) / 18).drawTooltip(guiGraphics, mouseX, mouseY);
        }
        if (mouseX > this.getGuiLeft() + this.DROPS_X && mouseX < this.getGuiLeft() + this.DROPS_X + 18 * this.DROPS_COLS && mouseY > this.getGuiTop() + this.DROPS_Y && mouseY < this.getGuiTop() + this.DROPS_Y + 18 * this.DROPS_ROWS) {
            this.dropElements.get((mouseY - (this.getGuiTop() + this.DROPS_Y)) / 18 * this.DROPS_COLS + (mouseX - (this.getGuiLeft() + this.DROPS_X)) / 18).drawTooltip(guiGraphics, mouseX, mouseY);
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        this.renderFg(guiGraphics, mouseX, mouseY);
        if (this.renderTime == 0L) {
            this.renderTime = Util.getMillis();
        }
        this.attemptRenderTooltip(guiGraphics, mouseX, mouseY);
        if (mouseX > this.getGuiLeft() + 226 && mouseX < this.getGuiLeft() + 241 && mouseY > this.getGuiTop() + 8 && mouseY < this.getGuiTop() + 91) {
            this.renderFluidTankTooltip(guiGraphics, mouseX, mouseY, ((HeartMenu)this.menu).getInputFluid(), this.getCapacity());
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float v, int mouseX, int mouseY) {
        int relX = (this.width - this.imageWidth) / 2;
        int relY = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(this.GUI, relX, relY, 0, 0, this.imageWidth, this.imageHeight);
        this.mobElements.forEach(e -> e.drawBackground(guiGraphics, mouseX, mouseY));
        this.upgradeElements.forEach(e -> e.drawBackground(guiGraphics, mouseX, mouseY));
        this.dropElements.forEach(e -> e.drawBackground(guiGraphics, mouseX, mouseY));
        this.recipeElements.forEach(e -> e.drawBackground(guiGraphics, mouseX, mouseY));
        this.exoticElement.drawBackground(mouseX, mouseY);
        int renderDiff = ((HeartMenu)this.menu).getInputFluid().getAmount() - this.currFluidRender;
        if (renderDiff != 0) {
            this.currFluidRender = Math.abs(renderDiff) < 20 ? ((HeartMenu)this.menu).getInputFluid().getAmount() : (this.currFluidRender += (int)Math.ceil((float)renderDiff * 0.08f));
        }
        this.renderFluidTank(guiGraphics, this.getGuiLeft() + 226, this.getGuiTop() + 91, 84, 16, this.getCapacity(), ((HeartMenu)this.menu).getInputFluid(), this.currFluidRender);
    }

    private boolean addToDropElements(int idx, FakeMob fakeMob, SimulatedMobDropSummary summary) {
        List tooltip = HeartScreen.getTooltipFromItem((Minecraft)this.getMinecraft(), (ItemStack)summary.stack());
        EntityType entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(fakeMob.getResourceLocation());
        if (entityType != null) {
            MutableComponent iTextComponent = Component.translatable((String)entityType.getDescriptionId());
            int index = 0;
            if (((HeartMenu)this.menu).getTileEntity().clientFactorySetup.perks.contains((Object)Perk.looting_1)) {
                index = 1;
            } else if (((HeartMenu)this.menu).getTileEntity().clientFactorySetup.perks.contains((Object)Perk.looting_2)) {
                index = 2;
            } else if (((HeartMenu)this.menu).getTileEntity().clientFactorySetup.perks.contains((Object)Perk.looting_3)) {
                index = 3;
            }
            tooltip.add(Component.literal((String)String.format("%s : %.2f%%", iTextComponent.getString(), summary.chanceToDrop().get(index))));
        }
        boolean found = false;
        for (GuiItemStackElement guiItemStackElement : this.dropElements) {
            if (!guiItemStackElement.itemStack.is(summary.stack().getItem())) continue;
            guiItemStackElement.addToolTip(tooltip);
            found = true;
            break;
        }
        if (!found) {
            this.dropElements.get(idx).setItemStack(summary.stack());
            this.dropElements.get(idx).addToolTip(tooltip);
            return true;
        }
        return false;
    }

    protected void renderFg(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        ClientFactorySetup clientFactorySetup = ((HeartMenu)this.menu).getTileEntity().clientFactorySetup;
        if (clientFactorySetup == null) {
            return;
        }
        if (!this.sync) {
            GuiStackElement stackElement;
            ArrayList<Component> tooltip;
            int idx = 0;
            ArrayList<FakeMob> knownMobs = new ArrayList<FakeMob>();
            for (FakeMob fakeMob : clientFactorySetup.controllerMobs) {
                if (knownMobs.contains(fakeMob)) continue;
                knownMobs.add(fakeMob);
                ClientFactorySetup.Mob mobInfo = clientFactorySetup.mobInfo.get(fakeMob);
                for (SimulatedMobDropSummary simulatedMobDropSummary : mobInfo.drops()) {
                    if (!this.addToDropElements(idx, fakeMob, simulatedMobDropSummary)) continue;
                    idx = (idx + 1) % this.dropElements.size();
                }
            }
            if (clientFactorySetup.tier != Tier.TIER_1) {
                for (int i = 0; i < 4; ++i) {
                    this.mobElements.get(i).unlock();
                    this.upgradeElements.get(i).unlock();
                }
            } else {
                this.mobElements.get(0).unlock();
                this.upgradeElements.get(0).unlock();
            }
            idx = 0;
            for (FakeMob fakeMob : clientFactorySetup.controllerMobs) {
                ItemStack controllerStack = ControllerBlockEntity.getItemStack(fakeMob);
                tooltip = HeartScreen.getTooltipFromItem((Minecraft)this.getMinecraft(), (ItemStack)controllerStack);
                this.mobElements.get(idx).setItemStack(controllerStack);
                this.mobElements.get(idx).addToolTip((List<Component>)tooltip);
                this.mobElements.get(idx).unlock();
                ++idx;
            }
            idx = 0;
            for (Perk perk : clientFactorySetup.perks) {
                ItemStack itemStack = PerkItem.getItemStack(perk);
                tooltip = HeartScreen.getTooltipFromItem((Minecraft)this.getMinecraft(), (ItemStack)itemStack);
                for (FakeMob fakeMob : clientFactorySetup.controllerMobs) {
                    MobParam mobParam = clientFactorySetup.mobParams.get(fakeMob);
                    EntityType entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(fakeMob.getResourceLocation());
                    MutableComponent iTextComponent = Component.translatable((String)entityType.getDescriptionId());
                    if (Perk.EFFICIENCY_PERKS.contains((Object)perk)) {
                        tooltip.add((Component)Component.literal((String)String.format("%s : %d%%", iTextComponent.getString(), mobParam.getPerkEfficiencyValue())));
                        continue;
                    }
                    if (Perk.RATE_PERKS.contains((Object)perk)) {
                        tooltip.add((Component)Component.literal((String)String.format("%s : %d%%", iTextComponent.getString(), mobParam.getPerkRateValue())));
                        continue;
                    }
                    if (Perk.MASS_PERKS.contains((Object)perk)) {
                        tooltip.add((Component)Component.literal((String)String.format("%s : %d mobs", iTextComponent.getString(), mobParam.getMobCount(true, clientFactorySetup.exotic == Exotic.EXOTIC_E))));
                        continue;
                    }
                    if (!Perk.XP_PERKS.contains((Object)perk)) continue;
                    tooltip.add((Component)Component.literal((String)String.format("%s : %d%%", iTextComponent.getString(), mobParam.getPerkXpValue())));
                }
                if (Perk.TIER_SHARD_PERKS.contains((Object)perk)) {
                    tooltip.add((Component)Component.literal((String)String.format("%d rolls @ %.2f%%", clientFactorySetup.shardRolls, clientFactorySetup.shardDropChance)));
                    tooltip.add((Component)Component.literal((String)String.format("Basic: %.2f%%", clientFactorySetup.shardDrops[0])));
                    tooltip.add((Component)Component.literal((String)String.format("Advanced: %.2f%%", clientFactorySetup.shardDrops[1])));
                    tooltip.add((Component)Component.literal((String)String.format("Elite: %.2f%%", clientFactorySetup.shardDrops[2])));
                }
                if (clientFactorySetup.perkCapped) {
                    MutableComponent mutableComponent = Component.translatable((String)clientFactorySetup.tier.getTranslationKey());
                    MutableComponent iTextComponent2 = Component.translatable((String)"gui.woot.heart.8");
                    tooltip.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.RED) + String.format("%s : %s", iTextComponent2.getString(), mutableComponent.getString()))));
                }
                this.upgradeElements.get(idx).setItemStack(itemStack);
                this.upgradeElements.get(idx).addToolTip(tooltip);
                this.upgradeElements.get(idx).unlock();
                idx = (idx + 1) % this.upgradeElements.size();
            }
            idx = 0;
            for (ItemStack itemStack : clientFactorySetup.itemIng) {
                stackElement = new GuiItemStackElement(this.RECIPE_X + idx * 18, this.RECIPE_Y);
                tooltip = HeartScreen.getTooltipFromItem((Minecraft)this.getMinecraft(), (ItemStack)itemStack);
                tooltip.add((Component)Component.literal((String)String.format("%d items", itemStack.getCount())));
                ((GuiItemStackElement)stackElement).setItemStack(itemStack.copy());
                ((GuiItemStackElement)stackElement).addToolTip(tooltip);
                this.recipeElements.add(stackElement);
                ++idx;
            }
            for (FluidStack fluidStack : clientFactorySetup.fluidIng) {
                stackElement = new GuiFluidStackElement(this.RECIPE_X + idx * 18, this.RECIPE_Y);
                tooltip = new ArrayList<Component>();
                tooltip.add(fluidStack.getHoverName());
                tooltip.add((Component)Component.literal((String)String.format("%d mb", fluidStack.getAmount())));
                ((GuiFluidStackElement)stackElement).setStack(fluidStack.copy());
                ((GuiFluidStackElement)stackElement).addTooltip(tooltip);
                this.recipeElements.add(stackElement);
                ++idx;
            }
            this.sync = true;
        }
        if (clientFactorySetup.tier != Tier.TIER_5) {
            this.exoticElement.isLocked = true;
        } else if (clientFactorySetup.exotic != Exotic.NONE) {
            List tooltip = HeartScreen.getTooltipFromItem((Minecraft)this.getMinecraft(), (ItemStack)clientFactorySetup.exotic.getItemStack());
            this.exoticElement.addDrop(clientFactorySetup.exotic.getItemStack(), tooltip);
        }
        this.addInfoLine(guiGraphics, 0, StringHelper.translate("gui.woot.heart.0"), this.title.getString());
        this.addInfoLine(guiGraphics, 1, StringHelper.translate(new FluidStack((Fluid)FluidSetup.CONATUS_FLUID.get(), 1).getDescriptionId()), clientFactorySetup.recipeFluid + " mB");
        this.addInfoLine(guiGraphics, 2, StringHelper.translate("gui.woot.heart.1"), clientFactorySetup.recipeTicks + " ticks");
        this.addInfoLine(guiGraphics, 3, StringHelper.translate("gui.woot.heart.2"), ((HeartMenu)this.menu).getProgress() + "%");
        guiGraphics.drawString(this.font, StringHelper.translate("gui.woot.heart.3"), this.getGuiLeft() + this.MOBS_X, this.getGuiTop() + this.MOBS_Y - 10, this.TEXT_COLOR, false);
        guiGraphics.drawString(this.font, StringHelper.translate("gui.woot.heart.4"), this.getGuiLeft() + this.PERKS_X, this.getGuiTop() + this.PERKS_Y - 10, this.TEXT_COLOR, false);
        guiGraphics.drawString(this.font, StringHelper.translate("gui.woot.heart.5"), this.getGuiLeft() + this.DROPS_X, this.getGuiTop() + this.DROPS_Y - 10, this.TEXT_COLOR, false);
        guiGraphics.drawString(this.font, StringHelper.translate("gui.woot.heart.6"), this.getGuiLeft() + this.RECIPE_X, this.getGuiTop() + this.RECIPE_Y - 10, this.TEXT_COLOR, false);
        guiGraphics.drawString(this.font, StringHelper.translate("gui.woot.heart.7"), this.getGuiLeft() + EXOTIC_X, this.getGuiTop() + EXOTIC_Y - 10, this.TEXT_COLOR, false);
        this.mobElements.forEach(e -> e.drawForeground(guiGraphics, mouseX, mouseY));
        this.upgradeElements.forEach(e -> e.drawForeground(guiGraphics, mouseX, mouseY));
        this.recipeElements.forEach(e -> e.drawForeground(guiGraphics, mouseX, mouseY));
        this.dropElements.forEach(e -> e.drawForeground(guiGraphics, mouseX, mouseY));
        this.exoticElement.drawForeground(guiGraphics, mouseX, mouseY);
    }

    private void addInfoLine(GuiGraphics guiGraphics, int offset, String tag, String value) {
        int INFO_X = 10;
        int INFO_Y = 10;
        int TEXT_HEIGHT = 10;
        guiGraphics.drawString(this.font, tag, this.getGuiLeft() + INFO_X, this.getGuiTop() + INFO_Y + TEXT_HEIGHT * offset, this.TEXT_COLOR, false);
        guiGraphics.drawString(this.font, value, this.getGuiLeft() + INFO_X + 80, this.getGuiTop() + INFO_Y + TEXT_HEIGHT * offset, this.TEXT_COLOR, false);
    }

    class StackElement {
        int x;
        int y;
        boolean isLocked = false;
        int idx = 0;
        List<ItemStack> itemStacks = new ArrayList<ItemStack>();
        List<List<Component>> tooltips = new ArrayList<List<Component>>();

        public StackElement(int x, int y, boolean locked) {
            this.x = x;
            this.y = y;
            this.isLocked = locked;
        }

        public StackElement(int x, int y) {
            this(x, y, false);
        }

        public void addDrop(ItemStack itemStack, List<Component> tooltip) {
            this.isLocked = false;
            this.itemStacks.add(itemStack);
            this.tooltips.add(tooltip);
        }

        public void unlock() {
            this.isLocked = false;
        }

        public void cycle() {
            if (!this.itemStacks.isEmpty()) {
                this.idx = (this.idx + 1) % this.itemStacks.size();
            }
        }

        public void drawBackground(int mouseX, int mouseY) {
            if (this.isLocked) {
                return;
            }
            if (this.itemStacks.isEmpty()) {
                return;
            }
        }

        public void drawTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
            if (this.isLocked) {
                return;
            }
            if (this.itemStacks.isEmpty()) {
                return;
            }
            ItemStack itemStack = this.itemStacks.get(this.idx);
            List<Component> tooltip = this.tooltips.get(this.idx);
            guiGraphics.renderTooltip(HeartScreen.this.font, tooltip, Optional.empty(), mouseX, mouseY);
        }

        public void drawForeground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
            if (this.isLocked) {
                return;
            }
            if (this.itemStacks.isEmpty()) {
                return;
            }
            ItemStack itemStack = this.itemStacks.get(this.idx);
            guiGraphics.renderItem(itemStack, HeartScreen.this.getGuiLeft() + this.x, HeartScreen.this.getGuiTop() + this.y, 100, 100);
        }
    }

    public class GuiItemStackElement
    extends GuiStackElement {
        private ItemStack itemStack;
        List<Component> tooltip;

        public GuiItemStackElement(int posX, int posY, boolean isLocked) {
            super(HeartScreen.this, posX, posY, isLocked);
            this.tooltip = new ArrayList<Component>();
            this.itemStack = ItemStack.EMPTY;
        }

        public GuiItemStackElement(int posX, int posY) {
            super(HeartScreen.this, posX, posY);
            this.tooltip = new ArrayList<Component>();
            this.itemStack = ItemStack.EMPTY;
        }

        public void setItemStack(ItemStack itemStack) {
            this.itemStack = itemStack.copy();
        }

        public void addToolTip(List<Component> tooltip) {
            this.tooltip.addAll(tooltip);
        }

        @Override
        public void drawBackground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
            if (this.isLocked || this.itemStack.isEmpty()) {
                return;
            }
        }

        @Override
        public void drawForeground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
            super.drawForeground(guiGraphics, mouseX, mouseY);
            if (this.itemStack.isEmpty()) {
                return;
            }
            guiGraphics.renderItem(this.itemStack, HeartScreen.this.getGuiLeft() + this.posX, HeartScreen.this.getGuiTop() + this.posY, 100, 0);
        }

        @Override
        public void drawTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
            if (this.isLocked || this.itemStack.isEmpty() || this.tooltip.isEmpty()) {
                return;
            }
            if (!RenderHelper.isPointInRegion(this.posX, this.posY, 16, 16, mouseX, mouseY, HeartScreen.this.getGuiLeft(), HeartScreen.this.getGuiTop())) {
                return;
            }
            guiGraphics.renderTooltip(HeartScreen.this.font, this.tooltip, Optional.empty(), mouseX, mouseY);
        }
    }

    class GuiStackElement {
        int posX;
        int posY;
        boolean isLocked = false;

        public GuiStackElement(HeartScreen this$0) {
        }

        public GuiStackElement(HeartScreen this$0, int posX, int posY) {
            this(this$0);
            this.posX = posX;
            this.posY = posY;
        }

        public GuiStackElement(HeartScreen this$0, int posX, int posY, boolean isLocked) {
            this(this$0, posX, posY);
            this.isLocked = isLocked;
        }

        public void unlock() {
            this.isLocked = false;
        }

        public void lock() {
            this.isLocked = true;
        }

        public void drawBackground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        }

        public void drawForeground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
            if (this.isLocked) {
                // empty if block
            }
        }

        public void drawTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        }
    }

    public class GuiFluidStackElement
    extends GuiStackElement {
        private FluidStack fluidStack;
        private List<Component> tooltip;

        public GuiFluidStackElement(int posX, int posY, boolean isLocked) {
            super(HeartScreen.this, posX, posY, isLocked);
            this.tooltip = new ArrayList<Component>();
            this.fluidStack = FluidStack.EMPTY;
        }

        public GuiFluidStackElement(int posX, int posY) {
            super(HeartScreen.this, posX, posY);
            this.tooltip = new ArrayList<Component>();
            this.fluidStack = FluidStack.EMPTY;
        }

        public void setStack(FluidStack fluidStack) {
            this.fluidStack = fluidStack.copy();
        }

        public void addTooltip(List<Component> tooltip) {
            this.tooltip.addAll(tooltip);
        }

        @Override
        public void drawBackground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
            if (this.isLocked || this.fluidStack.isEmpty()) {
                return;
            }
            HeartScreen.this.drawFluid(guiGraphics, HeartScreen.this.getGuiLeft() + this.posX, HeartScreen.this.getGuiTop() + this.posY, this.fluidStack, 16, 16);
        }

        @Override
        public void drawForeground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
            super.drawForeground(guiGraphics, mouseX, mouseY);
        }

        @Override
        public void drawTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
            if (this.isLocked || this.fluidStack.isEmpty() || this.tooltip.isEmpty()) {
                return;
            }
            if (!RenderHelper.isPointInRegion(this.posX, this.posY, 16, 16, mouseX, mouseY, HeartScreen.this.getRectangle().left(), HeartScreen.this.getRectangle().top())) {
                return;
            }
            guiGraphics.renderTooltip(HeartScreen.this.font, this.tooltip, Optional.empty(), mouseX, mouseY);
        }
    }
}

