/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.factory.generators;

import ipsis.woot.modules.factory.FormedSetup;
import ipsis.woot.modules.factory.blocks.ExporterBlockEntity;
import ipsis.woot.modules.factory.blocks.HeartBlockEntity;
import ipsis.woot.modules.factory.generators.IndustrialForegoingGenerator;
import ipsis.woot.modules.factory.generators.SkullGenerator;
import ipsis.woot.modules.factory.generators.WoolGenerator;
import ipsis.woot.modules.factory.items.XpShardBaseItem;
import ipsis.woot.modules.factory.perks.Perk;
import ipsis.woot.modules.generic.GenericSetup;
import ipsis.woot.policy.PolicyConfiguration;
import ipsis.woot.simulator.MobSimulator;
import ipsis.woot.simulator.spawning.SpawnController;
import ipsis.woot.util.FakeMob;
import ipsis.woot.util.FakeMobKey;
import ipsis.woot.util.helper.RandomHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.FluidStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LootGeneration {
    static final Logger LOGGER = LogManager.getLogger();
    static final RandomSource RANDOM = RandomSource.create();
    static final SkullGenerator SKULL_GENERATOR = new SkullGenerator();
    static LootGeneration INSTANCE = new LootGeneration();

    public static LootGeneration get() {
        return INSTANCE;
    }

    public void loadFromConfig() {
        SKULL_GENERATOR.loadFromConfig((List)PolicyConfiguration.MOB_PERK_HEADLESS_SKULLS.get());
    }

    public void generate(HeartBlockEntity heartTileEntity, FormedSetup setup) {
        ExporterBlockEntity export = (ExporterBlockEntity)heartTileEntity.getLevel().getBlockEntity(setup.getExportPos());
        int looting = setup.getLootingLevel();
        ArrayList<ItemStack> rolledDrops = new ArrayList<ItemStack>();
        for (FakeMob fakeMob : setup.getAllMobs()) {
            int mobCount = setup.getAllMobParams().get(fakeMob).getMobCount(setup.getAllPerks().containsKey((Object)Perk.Group.mass), setup.hasMassExotic());
            FakeMobKey fakeMobKey = new FakeMobKey(fakeMob, looting);
            for (int i = 0; i < mobCount; ++i) {
                rolledDrops.addAll(MobSimulator.getInstance().getRolledDrops(fakeMobKey));
            }
            for (ItemStack itemStack : rolledDrops) {
                if (itemStack.isDamageableItem()) {
                    int dmg = RandomHelper.RANDOM.nextInt(itemStack.getMaxDamage() + 1);
                    dmg = Math.clamp((long)dmg, 1, itemStack.getMaxDamage());
                    itemStack.setDamageValue(dmg);
                }
                if (!itemStack.isEnchanted()) continue;
                if (itemStack.has(DataComponents.ENCHANTMENTS)) {
                    itemStack.remove(DataComponents.ENCHANTMENTS);
                }
                float f = setup.getWorld().getCurrentDifficultyAt(heartTileEntity.getBlockPos()).getEffectiveDifficulty();
                EnchantmentHelper.enchantItem((RandomSource)RandomHelper.RANDOM, (ItemStack)itemStack, (int)((int)(5.0f + f * (float)RandomHelper.RANDOM.nextInt(18))), (RegistryAccess)heartTileEntity.getLevel().registryAccess(), Optional.empty());
            }
            if (!fakeMobKey.getMob().isSheep()) continue;
            for (ItemStack itemStack : rolledDrops) {
                if (!WoolGenerator.isWoolDrop(itemStack)) continue;
                itemStack.setCount(0);
            }
            for (int i = 0; i < mobCount; ++i) {
                rolledDrops.add(WoolGenerator.getWoolDrop(fakeMobKey.getMob()));
            }
        }
        export.insertStacks(rolledDrops);
        if (setup.getAllPerks().containsKey((Object)Perk.Group.xp)) {
            int genXp = 0;
            for (FakeMob mob : setup.getAllMobs()) {
                int xpPercent = setup.getAllMobParams().get(mob).getPerkXpValue();
                int mobCount = setup.getAllMobParams().get(mob).getMobCount(setup.getAllPerks().containsKey((Object)Perk.Group.mass), setup.hasMassExotic());
                int x = (int)((float)SpawnController.get().getMobExperience(mob, setup.getWorld()) / 100.0f * (float)xpPercent);
                genXp += x * mobCount;
            }
            List<ItemStack> list = XpShardBaseItem.getShards(genXp);
            export.insertStacks(list);
        }
        if (setup.getAllPerks().containsKey((Object)Perk.Group.tier_shard)) {
            ArrayList<WeightedEntry.Wrapper> shards = new ArrayList<WeightedEntry.Wrapper>();
            shards.add(WeightedEntry.wrap((Object)new ItemStack((ItemLike)GenericSetup.T1_SHARD_ITEM.get()), (int)setup.getBasicShardWeight()));
            shards.add(WeightedEntry.wrap((Object)new ItemStack((ItemLike)GenericSetup.T2_SHARD_ITEM.get()), (int)setup.getAdvancedShardWeight()));
            shards.add(WeightedEntry.wrap((Object)new ItemStack((ItemLike)GenericSetup.T3_SHARD_ITEM.get()), (int)setup.getEliteShardWeight()));
            int n = setup.getPerkTierShardValue();
            ArrayList<ItemStack> dropShards = new ArrayList<ItemStack>();
            for (int i = 0; i < n; ++i) {
                if (!RandomHelper.rollPercentage(setup.getShardDropChance(), "shardGen")) continue;
                ItemStack chosenShard = (ItemStack)((WeightedEntry.Wrapper)WeightedRandom.getRandomItem((RandomSource)RANDOM, shards).get()).data();
                dropShards.add(chosenShard);
            }
            export.insertStacks(dropShards);
        }
        if (setup.getAllPerks().containsKey((Object)Perk.Group.headless)) {
            ArrayList<ItemStack> skulls = new ArrayList<ItemStack>();
            List<FakeMob> list = setup.getAllMobs().stream().map(m -> {
                int mobCount = setup.getAllMobParams().get(m).getMobCount(setup.getAllPerks().containsKey((Object)Perk.Group.mass), setup.hasMassExotic());
                return Collections.nCopies(mobCount, m);
            }).flatMap(Collection::stream).collect(Collectors.toList());
            list.forEach(m -> skulls.add(SKULL_GENERATOR.getSkullDrop((FakeMob)m, setup.getAllMobParams().get(m).getPerkHeadlessValue())));
            export.insertStacks(skulls);
        }
        if (setup.getAllPerks().containsKey((Object)Perk.Group.slaughter) || setup.getAllPerks().containsKey((Object)Perk.Group.crusher) || setup.getAllPerks().containsKey((Object)Perk.Group.laser)) {
            IndustrialForegoingGenerator.GeneratedFluids fluids = IndustrialForegoingGenerator.getFluids(setup, setup.getWorld());
            if (setup.getAllPerks().containsKey((Object)Perk.Group.slaughter) && !fluids.meat.isEmpty() && !fluids.pink.isEmpty()) {
                ArrayList<FluidStack> arrayList = new ArrayList<FluidStack>();
                arrayList.add(fluids.meat);
                arrayList.add(fluids.pink);
                export.insertFluids(arrayList);
            }
            if (setup.getAllPerks().containsKey((Object)Perk.Group.crusher) && !fluids.essence.isEmpty()) {
                ArrayList<FluidStack> arrayList = new ArrayList<FluidStack>();
                arrayList.add(fluids.essence);
                export.insertFluids(arrayList);
            }
            if (setup.getAllPerks().containsKey((Object)Perk.Group.laser) && !fluids.ether.isEmpty()) {
                ArrayList<FluidStack> arrayList = new ArrayList<FluidStack>();
                arrayList.add(fluids.ether);
                export.insertFluids(arrayList);
            }
        }
    }
}

