/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.factory.items;

import ipsis.woot.Woot;
import ipsis.woot.config.Config;
import ipsis.woot.config.ConfigOverride;
import ipsis.woot.modules.factory.FactorySetup;
import ipsis.woot.policy.PolicyConfiguration;
import ipsis.woot.policy.PolicyRegistry;
import ipsis.woot.util.FakeMob;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class MobShardItem
extends Item {
    private static final String NBT_MOB = "Mob";
    private static final String NBT_KILLS = "Kills";

    public MobShardItem() {
        super(new Item.Properties().stacksTo(1));
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        Woot.setup.getLogger().debug((Object)target.getName());
        if (attacker.level().isClientSide || !(attacker instanceof Player)) {
            return false;
        }
        if (!(target instanceof Mob)) {
            return false;
        }
        if (MobShardItem.isProgrammed(stack)) {
            return false;
        }
        FakeMob fakeMob = new FakeMob((Mob)target);
        if (!fakeMob.isValid()) {
            return false;
        }
        if (!PolicyRegistry.get().canCaptureEntity(fakeMob.getResourceLocation()) || !MobShardItem.canShardCaptureMob(fakeMob.getResourceLocation())) {
            attacker.sendSystemMessage((Component)Component.translatable((String)"chat.woot.mobshard.failure"));
            return false;
        }
        this.setProgrammedMob(stack, fakeMob);
        attacker.sendSystemMessage((Component)Component.translatable((String)"chat.woot.mobshard.success"));
        return true;
    }

    private static boolean canShardCaptureMob(ResourceLocation resourceLocation) {
        for (String s : (List)PolicyConfiguration.SHARD_BLACKLIST_FULL_MOD.get()) {
            if (!s.equalsIgnoreCase(resourceLocation.getNamespace())) continue;
            return false;
        }
        for (String s : (List)PolicyConfiguration.SHARD_BLACKLIST_ENTITY.get()) {
            if (!s.equalsIgnoreCase(resourceLocation.toString())) continue;
            return false;
        }
        return true;
    }

    public static boolean isProgrammed(ItemStack itemStack) {
        return MobShardItem.getProgrammedMob(itemStack).isValid();
    }

    public static FakeMob getProgrammedMob(ItemStack itemStack) {
        CompoundTag tag;
        FakeMob fakeMob = new FakeMob();
        CustomData data = (CustomData)itemStack.get(DataComponents.CUSTOM_DATA);
        CompoundTag compoundTag = tag = data == null ? new CompoundTag() : data.copyTag();
        if (tag.contains(NBT_MOB)) {
            fakeMob = new FakeMob(tag.getCompound(NBT_MOB));
        }
        return fakeMob;
    }

    private void setProgrammedMob(ItemStack itemStack, FakeMob fakeMob) {
        CompoundTag mobNbt = new CompoundTag();
        FakeMob.writeToNBT(fakeMob, mobNbt);
        CustomData data = (CustomData)itemStack.get(DataComponents.CUSTOM_DATA);
        CompoundTag tag = data == null ? new CompoundTag() : data.copyTag();
        tag.put(NBT_MOB, (Tag)mobNbt);
        tag.putInt(NBT_KILLS, 0);
        itemStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
    }

    private static boolean isMatchingMob(ItemStack itemStack, FakeMob fakeMob) {
        if (itemStack.getItem() != FactorySetup.MOB_SHARD_ITEM.get()) {
            return false;
        }
        if (!MobShardItem.isProgrammed(itemStack)) {
            return false;
        }
        FakeMob programmedMob = MobShardItem.getProgrammedMob(itemStack);
        if (!programmedMob.isValid()) {
            return false;
        }
        return programmedMob.equals(fakeMob);
    }

    public static void handleKill(Player playerEntity, FakeMob fakeMob) {
        ItemStack foundStack = ItemStack.EMPTY;
        for (int i = 0; i <= 9; ++i) {
            ItemStack itemStack = playerEntity.getInventory().getItem(i);
            if (itemStack.isEmpty() || !MobShardItem.isMatchingMob(itemStack, fakeMob)) continue;
            foundStack = itemStack;
            break;
        }
        if (!foundStack.isEmpty()) {
            MobShardItem.incrementKills(foundStack, 1);
        }
    }

    private static void incrementKills(ItemStack itemStack, int v) {
        if (itemStack.getItem() != FactorySetup.MOB_SHARD_ITEM.get()) {
            return;
        }
        FakeMob fakeMob = MobShardItem.getProgrammedMob(itemStack);
        if (!fakeMob.isValid()) {
            return;
        }
        if (!PolicyRegistry.get().canCaptureEntity(fakeMob.getResourceLocation()) || !MobShardItem.canShardCaptureMob(fakeMob.getResourceLocation())) {
            return;
        }
        CustomData data = (CustomData)itemStack.get(DataComponents.CUSTOM_DATA);
        CompoundTag tag = data == null ? new CompoundTag() : data.copyTag();
        tag.putInt(NBT_KILLS, tag.getInt(NBT_KILLS) + v);
        itemStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
        if (MobShardItem.isFull(itemStack) && MobShardItem.isProgrammed(itemStack)) {
            itemStack.set(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, (Object)true);
        }
    }

    private static boolean isFull(ItemStack itemStack) {
        int killCount = ((CustomData)itemStack.get(DataComponents.CUSTOM_DATA)).copyTag().getInt(NBT_KILLS);
        FakeMob fakeMob = MobShardItem.getProgrammedMob(itemStack);
        if (!fakeMob.isValid()) {
            return false;
        }
        return killCount >= Config.OVERRIDE.getIntegerOrDefault(fakeMob, ConfigOverride.OverrideKey.SHARD_KILLS);
    }

    public static boolean isFullyProgrammed(ItemStack itemStack) {
        return MobShardItem.isProgrammed(itemStack) && MobShardItem.isFull(itemStack);
    }

    public static void setJEIEnderShard(ItemStack itemStack) {
        CompoundTag nbt = new CompoundTag();
        nbt.putInt("nbt_jei_shard", 1);
        itemStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)nbt));
        itemStack.set(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, (Object)true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        tooltip.add((Component)Component.translatable((String)"info.woot.mobshard.0"));
        tooltip.add((Component)Component.translatable((String)"info.woot.mobshard.1"));
        tooltip.add((Component)Component.translatable((String)"info.woot.mobshard.2"));
        tooltip.add((Component)Component.translatable((String)"info.woot.mobshard.3"));
        FakeMob fakeMob = MobShardItem.getProgrammedMob(stack);
        if (!fakeMob.isValid()) {
            tooltip.add((Component)Component.translatable((String)"info.woot.mobshard.a.0"));
            return;
        }
        EntityType entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(fakeMob.getResourceLocation());
        if (entityType != null) {
            tooltip.add((Component)Component.translatable((String)entityType.getDescriptionId()));
        }
        if (fakeMob.hasTag()) {
            tooltip.add((Component)Component.translatable((String)("[" + fakeMob.getTag() + "]")));
        }
        int killCount = ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).copyTag().getInt(NBT_KILLS);
        if (MobShardItem.isFull(stack)) {
            tooltip.add((Component)Component.translatable((String)"info.woot.mobshard.a.1"));
        } else {
            tooltip.add((Component)Component.translatable((String)"info.woot.mobshard.b.0", (Object[])new Object[]{killCount, Config.OVERRIDE.getIntegerOrDefault(fakeMob, ConfigOverride.OverrideKey.SHARD_KILLS)}));
        }
    }
}

