/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.factory.items;

import ipsis.woot.Woot;
import ipsis.woot.modules.factory.FactorySetup;
import ipsis.woot.util.helper.RandomHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.util.FakePlayer;

public class XpShardBaseItem
extends Item {
    public static final String SHARD_REGNAME = "xpshard";
    public static final String SPLINTER_REGNAME = "xpsplinter";
    private static final int STACK_SIZE = 64;
    public static final int SPLINTERS_IN_STACK = 9;
    private static final int SHARD_XP = 9;
    private static final int SPLINTER_XP = 1;
    final Variant variant;

    public XpShardBaseItem(Variant variant) {
        super(new Item.Properties().stacksTo(64));
        this.variant = variant;
    }

    public Variant getVariant() {
        return this.variant;
    }

    public static ItemStack getItemStack(Variant variant) {
        if (variant == Variant.SHARD) {
            return new ItemStack((ItemLike)FactorySetup.XP_SHARD_ITEM.get());
        }
        return new ItemStack((ItemLike)FactorySetup.XP_SPLINTER_ITEM.get());
    }

    public static List<ItemStack> getShards(int xp) {
        ArrayList<ItemStack> shards = new ArrayList<ItemStack>();
        int xpShards = xp / 9;
        int xpSplinters = xp % 9;
        int fullStacks = xpShards / 64;
        int leftoverShard = xpShards % 64;
        Woot.setup.getLogger().debug("getShards: xp {} xpShards {} xpSplinters {} fullStacks {} leftoverShards {}", (Object)xp, (Object)xpShards, (Object)xpSplinters, (Object)fullStacks, (Object)leftoverShard);
        for (int i = 0; i < fullStacks; ++i) {
            ItemStack itemStack = XpShardBaseItem.getItemStack(Variant.SHARD);
            itemStack.setCount(64);
            shards.add(itemStack);
        }
        if (leftoverShard > 0) {
            ItemStack itemStack = XpShardBaseItem.getItemStack(Variant.SHARD);
            itemStack.setCount(leftoverShard);
            shards.add(itemStack);
        }
        if (xpSplinters > 0) {
            ItemStack itemStack = XpShardBaseItem.getItemStack(Variant.SPLINTER);
            itemStack.setCount(xpSplinters);
            shards.add(itemStack);
        }
        return shards;
    }

    private int getXp(ItemStack itemStack) {
        if (itemStack.getItem() == FactorySetup.XP_SHARD_ITEM.get()) {
            return 9;
        }
        if (itemStack.getItem() == FactorySetup.XP_SPLINTER_ITEM.get()) {
            return 1;
        }
        return 0;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (!level.isClientSide) {
            return InteractionResultHolder.pass((Object)itemStack);
        }
        if (itemStack.isEmpty()) {
            return InteractionResultHolder.pass((Object)itemStack);
        }
        ItemStack advancementStack = itemStack.copy();
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 0.2f, 0.5f * ((RandomHelper.RANDOM.nextFloat() - RandomHelper.RANDOM.nextFloat()) * 0.7f + 1.8f));
        if (player instanceof FakePlayer) {
            level.addFreshEntity((Entity)new ExperienceOrb(level, player.getX(), player.getY(), player.getZ(), 1));
            itemStack.shrink(1);
        } else {
            int xp = 0;
            if (player.isCrouching()) {
                xp = this.getXp(itemStack) * itemStack.getCount();
                if (!player.isCreative()) {
                    itemStack.setCount(0);
                }
            } else {
                xp = this.getXp(itemStack);
                if (!player.isCreative()) {
                    itemStack.shrink(1);
                }
            }
            if (xp > 0) {
                player.giveExperiencePoints(xp);
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.CONSUME_ITEM.trigger((ServerPlayer)player, advancementStack);
                }
            }
        }
        return InteractionResultHolder.success((Object)itemStack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        tooltip.add((Component)Component.translatable((String)"info.woot.shard.0"));
        tooltip.add((Component)Component.translatable((String)"info.woot.shard.1"));
    }

    public static enum Variant {
        SHARD,
        SPLINTER;

    }
}

