/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.factory.layout;

import ipsis.woot.modules.factory.Exotic;
import ipsis.woot.modules.factory.FactoryComponent;
import ipsis.woot.modules.factory.Tier;
import ipsis.woot.modules.factory.layout.PatternBlock;
import ipsis.woot.modules.factory.layout.PatternRepository;
import ipsis.woot.modules.factory.perks.Perk;
import ipsis.woot.util.FakeMob;
import ipsis.woot.util.helper.BlockPosHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;

public class AbsolutePattern {
    Tier tier;
    Direction facing;
    List<PatternBlock> blocks = new ArrayList<PatternBlock>();
    List<Perk> perks = new ArrayList<Perk>();
    List<FakeMob> mobs = new ArrayList<FakeMob>();
    List<BlockPos> validControllerPos = new ArrayList<BlockPos>();
    Exotic exotic = Exotic.NONE;

    public List<PatternBlock> getBlocks() {
        return Collections.unmodifiableList(this.blocks);
    }

    public AbsolutePattern(Tier tier) {
        this.tier = tier;
    }

    public void addAbsoluteBlock(FactoryComponent component, BlockPos pos) {
        this.blocks.add(new PatternBlock(component, pos));
    }

    public Tier getTier() {
        return this.tier;
    }

    public Exotic getExotic() {
        return this.exotic;
    }

    public void addPerk(Perk perk) {
        this.perks.add(perk);
    }

    public void setExotic(Exotic exotic) {
        this.exotic = exotic;
    }

    public void clearPerks() {
        this.perks.clear();
    }

    public void addMob(FakeMob fakeMob) {
        this.mobs.add(fakeMob);
    }

    public void clearMobs() {
        this.mobs.clear();
    }

    public List<FakeMob> getMobs() {
        return Collections.unmodifiableList(this.mobs);
    }

    public void addControllerPos(BlockPos blockPos) {
        this.validControllerPos.add(blockPos);
    }

    public void clearControllerPos() {
        this.validControllerPos.clear();
    }

    public boolean isValidControllerPos(BlockPos blockPos) {
        return this.validControllerPos.contains(blockPos);
    }

    public static AbsolutePattern create(@Nonnull Level world, Tier tier, @Nonnull BlockPos origin, Direction facing) {
        PatternRepository.Pattern pattern = PatternRepository.get().getPattern(tier);
        AbsolutePattern absolutePattern = new AbsolutePattern(tier);
        Direction opposite = facing.getOpposite();
        for (PatternBlock patternBlock : pattern.getPatternBlocks()) {
            BlockPos pos = BlockPosHelper.rotateFromSouth(patternBlock.getBlockPos(), opposite);
            absolutePattern.addAbsoluteBlock(patternBlock.getFactoryComponent(), origin.offset((Vec3i)pos));
        }
        absolutePattern.facing = facing;
        return absolutePattern;
    }

    public String toString() {
        return "AbsolutePattern{tier=" + String.valueOf((Object)this.tier) + ", facing=" + String.valueOf(this.facing) + ", perks=" + String.valueOf(this.perks) + ", mobs=" + String.valueOf(this.mobs) + ", exotic=" + String.valueOf((Object)this.exotic) + "}";
    }
}

