/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.factory.layout;

import ipsis.woot.modules.factory.FactoryComponent;
import ipsis.woot.modules.factory.Tier;
import ipsis.woot.modules.factory.layout.AbsolutePattern;
import ipsis.woot.modules.factory.layout.FactoryScanner;
import ipsis.woot.modules.factory.layout.PatternBlock;
import ipsis.woot.modules.factory.multiblock.MultiBlockGlueProvider;
import ipsis.woot.modules.factory.multiblock.MultiBlockMaster;
import ipsis.woot.util.helper.PlayerHelper;
import ipsis.woot.util.helper.StringHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class FactoryHelper {
    public static void disconnectOld(Level world, AbsolutePattern absolutePattern) {
        for (PatternBlock pb : absolutePattern.getBlocks()) {
            BlockEntity te;
            if (!world.isLoaded(pb.getBlockPos()) || !((te = world.getBlockEntity(pb.getBlockPos())) instanceof MultiBlockGlueProvider)) continue;
            ((MultiBlockGlueProvider)te).getGlue().clearMaster();
        }
    }

    public static void connectNew(Level world, AbsolutePattern absolutePattern, MultiBlockMaster master) {
        for (PatternBlock pb : absolutePattern.getBlocks()) {
            BlockEntity te;
            if (pb.getFactoryComponent() == FactoryComponent.CONTROLLER && !absolutePattern.isValidControllerPos(pb.getBlockPos()) || !world.isLoaded(pb.getBlockPos()) || !((te = world.getBlockEntity(pb.getBlockPos())) instanceof MultiBlockGlueProvider)) continue;
            ((MultiBlockGlueProvider)te).getGlue().setMaster(master);
        }
    }

    static boolean isCorrectBlock(Block block, List<Block> validBlocks) {
        return validBlocks.contains(block);
    }

    public static BuildResult tryBuild(Level world, BlockPos pos, Player playerEntity, Direction facing, Tier tier) {
        if (!playerEntity.mayBuild()) {
            playerEntity.sendSystemMessage((Component)Component.translatable((String)"chat.woot.intern.noedit"));
            return BuildResult.ERROR;
        }
        boolean allPlaced = true;
        AbsolutePattern absolutePattern = AbsolutePattern.create(world, tier, pos, facing);
        for (PatternBlock pb : absolutePattern.getBlocks()) {
            BlockState currState = world.getBlockState(pb.getBlockPos());
            Block currBlock = currState.getBlock();
            List<Block> correctBlocks = pb.getFactoryComponent().getBlocks();
            List<ItemStack> correctItemStacks = pb.getFactoryComponent().getStacks();
            if (FactoryHelper.isCorrectBlock(currBlock, correctBlocks) || pb.getFactoryComponent() == FactoryComponent.CONTROLLER || pb.getFactoryComponent() == FactoryComponent.CELL) continue;
            allPlaced = false;
            Block placeBlock = correctBlocks.get(0);
            if (!PlayerHelper.playerHasFactoryComponent(playerEntity, correctItemStacks)) {
                playerEntity.sendSystemMessage((Component)Component.translatable((String)"chat.woot.intern.missingblock", (Object[])new Object[]{StringHelper.translate(pb.getFactoryComponent().getTranslationKey())}));
                return BuildResult.NO_BLOCK_IN_INV;
            }
            if (world.mayInteract(playerEntity, pb.getBlockPos()) && (world.isEmptyBlock(pb.getBlockPos()) || currState.canBeReplaced())) {
                ItemStack takenStack = PlayerHelper.takeFactoryComponent(playerEntity, correctItemStacks);
                if (!takenStack.isEmpty()) {
                    world.setBlock(pb.getBlockPos(), placeBlock.defaultBlockState(), 3);
                    ((ServerLevel)world).sendBlockUpdated(pb.getBlockPos(), placeBlock.defaultBlockState(), Blocks.AIR.defaultBlockState(), 2);
                }
                return BuildResult.SUCCESS;
            }
            playerEntity.sendSystemMessage((Component)Component.translatable((String)"chat.woot.intern.noreplace", (Object[])new Object[]{StringHelper.translate(pb.getFactoryComponent().getTranslationKey()), pb.getBlockPos().getX(), pb.getBlockPos().getY(), pb.getBlockPos().getZ()}));
            return BuildResult.ERROR;
        }
        return allPlaced ? BuildResult.ALL_BLOCKS_PLACED : BuildResult.ERROR;
    }

    public static void tryValidate(Level world, BlockPos pos, Player playerEntity, Direction facing, Tier tier) {
        playerEntity.sendSystemMessage((Component)Component.translatable((String)"chat.woot.intern.validate.start", (Object[])new Object[]{StringHelper.translate(tier.getTranslationKey())}));
        ArrayList<String> feedback = new ArrayList<String>();
        AbsolutePattern absolutePattern = AbsolutePattern.create(world, tier, pos, facing);
        if (!FactoryScanner.compareToWorld(absolutePattern, world, feedback)) {
            playerEntity.sendSystemMessage((Component)Component.literal((String)"----"));
            playerEntity.sendSystemMessage((Component)Component.translatable((String)"chat.woot.intern.validate.invalid", (Object[])new Object[]{StringHelper.translate(tier.getTranslationKey())}));
            for (String s : feedback) {
                playerEntity.sendSystemMessage((Component)Component.literal((String)s));
            }
            playerEntity.sendSystemMessage((Component)Component.literal((String)"----"));
        } else {
            playerEntity.sendSystemMessage((Component)Component.translatable((String)"chat.woot.intern.validate.valid", (Object[])new Object[]{StringHelper.translate(tier.getTranslationKey())}));
        }
    }

    public static enum BuildResult {
        ERROR,
        SUCCESS,
        NO_BLOCK_IN_INV,
        ALL_BLOCKS_PLACED;

    }
}

