/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.factory.layout;

import ipsis.woot.Woot;
import ipsis.woot.config.Config;
import ipsis.woot.modules.factory.Exotic;
import ipsis.woot.modules.factory.FactoryComponent;
import ipsis.woot.modules.factory.FactoryComponentProvider;
import ipsis.woot.modules.factory.Tier;
import ipsis.woot.modules.factory.blocks.ControllerBlockEntity;
import ipsis.woot.modules.factory.blocks.ExoticBlock;
import ipsis.woot.modules.factory.blocks.UpgradeBlock;
import ipsis.woot.modules.factory.layout.AbsolutePattern;
import ipsis.woot.modules.factory.layout.PatternBlock;
import ipsis.woot.modules.factory.perks.Perk;
import ipsis.woot.policy.PolicyRegistry;
import ipsis.woot.util.FakeMob;
import ipsis.woot.util.helper.StringHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FactoryScanner {
    private static final Logger LOGGER = LogManager.getLogger();

    @Nullable
    public static AbsolutePattern scanTier(Level world, Tier tier, BlockPos origin, Direction facing) {
        AbsolutePattern absolutePattern = AbsolutePattern.create(world, tier, origin, facing);
        return FactoryScanner.compareToWorldQuick(absolutePattern, world);
    }

    @Nullable
    public static AbsolutePattern scanForTier(Level world, BlockPos origin, Direction facing) {
        Tier tier;
        for (int i = Tier.VALUES.length - 1; i >= 0 && (tier = Tier.byIndex(i)) != Tier.UNKNOWN; --i) {
            AbsolutePattern absolutePattern = FactoryScanner.scanTier(world, tier, origin, facing);
            if (absolutePattern == null) continue;
            return absolutePattern;
        }
        return null;
    }

    @Nullable
    public static AbsolutePattern compareToWorldQuick(AbsolutePattern absolutePattern, Level world) {
        ArrayList<String> feedback = new ArrayList<String>();
        boolean valid = FactoryScanner.compareToWorld(absolutePattern, world, feedback);
        return valid ? absolutePattern : null;
    }

    public static boolean compareToWorld(AbsolutePattern absolutePattern, Level world, List<String> feedback) {
        boolean valid = true;
        boolean foundPrimaryController = false;
        Woot.setup.getLogger().debug("compareToWorld: {}", (Object)absolutePattern.getTier());
        BlockPos heartPos = null;
        for (PatternBlock p : absolutePattern.getBlocks()) {
            if (p.getFactoryComponent() != FactoryComponent.HEART) continue;
            heartPos = new BlockPos((Vec3i)p.getBlockPos());
        }
        if (heartPos == null) {
            return false;
        }
        BlockPos primaryControllerPos = BlockPos.of((long)BlockPos.offset((long)heartPos.asLong(), (Direction)absolutePattern.facing)).offset(0, -2, 0);
        if (absolutePattern.getTier() == Tier.TIER_5) {
            BlockState exoticBlockState = world.getBlockState(heartPos.above());
            if (exoticBlockState.getBlock() instanceof ExoticBlock) {
                Block b = exoticBlockState.getBlock();
                Exotic exotic = ((ExoticBlock)b).getExotic();
                absolutePattern.setExotic(((ExoticBlock)b).getExotic());
            }
        } else {
            absolutePattern.setExotic(Exotic.NONE);
        }
        for (PatternBlock p : absolutePattern.getBlocks()) {
            FakeMob fakeMob;
            BlockEntity te;
            BlockState blockState;
            if (!world.isLoaded(p.getBlockPos())) {
                valid = false;
                continue;
            }
            BlockState currState = world.getBlockState(p.getBlockPos());
            Block currBlock = currState.getBlock();
            String found = StringHelper.translate(currBlock.getDescriptionId());
            String expected = StringHelper.translate(p.getFactoryComponent().getTranslationKey());
            if (p.getFactoryComponent() == FactoryComponent.CELL) {
                expected = StringHelper.translate("info.woot.intern.cell");
            }
            if (!(currBlock instanceof FactoryComponentProvider)) {
                if (p.getFactoryComponent() == FactoryComponent.CONTROLLER) continue;
                feedback.add(StringHelper.translateFormat("chat.woot.intern.validate.missing", expected, p.getBlockPos().getX(), p.getBlockPos().getY(), p.getBlockPos().getZ()));
                valid = false;
                continue;
            }
            FactoryComponentProvider factoryComponent = (FactoryComponentProvider)currBlock;
            if (!FactoryComponent.isSameComponentFuzzy(factoryComponent.getFactoryComponent(), p.getFactoryComponent())) {
                feedback.add(StringHelper.translateFormat("chat.woot.intern.validate.incorrect", expected, p.getBlockPos().getX(), p.getBlockPos().getY(), p.getBlockPos().getZ(), found));
                valid = false;
                continue;
            }
            if (p.getFactoryComponent() == FactoryComponent.FACTORY_UPGRADE && (blockState = world.getBlockState(p.getBlockPos())).getValue(UpgradeBlock.UPGRADE) != Perk.empty) {
                absolutePattern.addPerk((Perk)((Object)blockState.getValue(UpgradeBlock.UPGRADE)));
            }
            if (p.getFactoryComponent() != FactoryComponent.CONTROLLER || !((te = world.getBlockEntity(p.getBlockPos())) instanceof ControllerBlockEntity) || !(fakeMob = ((ControllerBlockEntity)te).getFakeMob()).isValid()) continue;
            Tier mobTier = Config.OVERRIDE.getMobTier(fakeMob, world);
            if (!PolicyRegistry.get().canCaptureEntity(fakeMob.getResourceLocation())) {
                Woot.setup.getLogger().debug("compareToWorld:    {} is invalid policy", (Object)fakeMob);
                feedback.add(StringHelper.translateFormat("chat.woot.intern.validate.blacklisted", p.getBlockPos().getX(), p.getBlockPos().getY(), p.getBlockPos().getZ()));
                continue;
            }
            if (!absolutePattern.getTier().isValidForTier(mobTier)) {
                Woot.setup.getLogger().debug("compareToWorld: {} is invalid tier", (Object)fakeMob);
                feedback.add(StringHelper.translateFormat("chat.woot.intern.validate.wrongtier", new Object[]{p.getBlockPos().getX(), p.getBlockPos().getY(), p.getBlockPos().getZ(), absolutePattern.getTier()}));
                continue;
            }
            absolutePattern.addControllerPos(p.getBlockPos());
            if (primaryControllerPos.equals((Object)p.getBlockPos())) {
                Woot.setup.getLogger().debug("compareToWorld: Found primary controller {}", (Object)fakeMob);
                foundPrimaryController = true;
                absolutePattern.addMob(fakeMob);
                continue;
            }
            Woot.setup.getLogger().debug("compareToWorld: Found valid secondary controller {}", (Object)fakeMob);
            absolutePattern.addMob(fakeMob);
        }
        if (!foundPrimaryController) {
            feedback.add(StringHelper.translateFormat("chat.woot.intern.validate.noprimary", primaryControllerPos.getX(), primaryControllerPos.getY(), primaryControllerPos.getZ()));
            valid = false;
        }
        if (!valid) {
            absolutePattern.clearMobs();
            absolutePattern.clearControllerPos();
            absolutePattern.clearPerks();
        }
        LOGGER.debug("compareToWorld: {}", (Object)absolutePattern);
        return valid;
    }

    public static boolean isPatternEqual(@Nonnull Level world, AbsolutePattern pattern1, AbsolutePattern pattern2) {
        if (pattern1 == null || pattern2 == null) {
            return false;
        }
        if (pattern1.tier != pattern2.tier) {
            return false;
        }
        if (pattern1.mobs.size() != pattern2.mobs.size()) {
            return false;
        }
        for (FakeMob fakeMob : pattern1.mobs) {
            if (pattern2.mobs.contains(fakeMob)) continue;
            return false;
        }
        if (pattern1.perks.size() != pattern2.perks.size()) {
            return false;
        }
        if (pattern1.exotic != pattern2.exotic) {
            return false;
        }
        for (Perk perk : pattern2.perks) {
            if (pattern1.perks.contains((Object)perk)) continue;
            return false;
        }
        return true;
    }
}

