/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.factory.layout;

import ipsis.woot.modules.factory.blocks.HeartBlockEntity;
import ipsis.woot.modules.factory.layout.AbsolutePattern;
import ipsis.woot.modules.factory.layout.FactoryHelper;
import ipsis.woot.modules.factory.layout.FactoryScanner;
import ipsis.woot.modules.factory.multiblock.MultiBlockMaster;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Layout {
    private static final Logger LOGGER = LogManager.getLogger();
    Level world;
    BlockPos pos;
    Direction facing = Direction.SOUTH;
    AbsolutePattern absolutePattern = null;
    boolean changed = false;
    boolean dirty = false;

    public boolean hasChanged() {
        return this.changed;
    }

    public void clearChanged() {
        this.changed = false;
    }

    public void setDirty() {
        this.dirty = true;
    }

    public boolean isFormed() {
        return this.absolutePattern != null;
    }

    @Nullable
    public AbsolutePattern getAbsolutePattern() {
        return this.absolutePattern;
    }

    public void setLocation(Level world, BlockPos pos, Direction facing) {
        this.world = world;
        this.pos = pos;
        this.facing = facing;
    }

    void handleDirty(MultiBlockMaster master) {
        AbsolutePattern rescannedPattern = FactoryScanner.scanForTier(this.world, this.pos, this.facing);
        if (this.absolutePattern != null || rescannedPattern != null) {
            if (this.absolutePattern == null && rescannedPattern != null) {
                FactoryHelper.connectNew(this.world, rescannedPattern, master);
                this.absolutePattern = rescannedPattern;
                this.changed = true;
            } else if (this.absolutePattern != null && rescannedPattern == null) {
                FactoryHelper.disconnectOld(this.world, this.absolutePattern);
                this.absolutePattern = null;
                this.changed = true;
            } else if (this.absolutePattern != null && rescannedPattern != null && !FactoryScanner.isPatternEqual(this.world, this.absolutePattern, rescannedPattern)) {
                FactoryHelper.disconnectOld(this.world, this.absolutePattern);
                FactoryHelper.connectNew(this.world, rescannedPattern, master);
                this.absolutePattern = rescannedPattern;
                this.changed = true;
            }
        }
    }

    public void tick(HeartBlockEntity.TickTracker tickTracker, MultiBlockMaster master) {
        if (!tickTracker.hasStructureTickExpired()) {
            return;
        }
        if (this.dirty) {
            this.handleDirty(master);
            tickTracker.resetStructureTickCount();
            this.dirty = false;
        }
    }

    public void fullDisconnect() {
        if (this.absolutePattern != null) {
            FactoryHelper.disconnectOld(this.world, this.absolutePattern);
        }
    }

    public String toString() {
        return "facing:" + String.valueOf(this.facing) + " pattern:" + (this.absolutePattern != null ? "yes" : "no") + " changed:" + this.changed + " dirty:" + this.dirty;
    }
}

