/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.factory.multiblock;

import ipsis.woot.modules.factory.multiblock.GlueHelper;
import ipsis.woot.modules.factory.multiblock.MultiBlockGlue;
import ipsis.woot.modules.factory.multiblock.MultiBlockGlueProvider;
import ipsis.woot.modules.factory.multiblock.MultiBlockMaster;
import ipsis.woot.util.helper.WorldHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Glue
implements MultiBlockGlue {
    private static final Logger LOGGER = LogManager.getLogger();
    private MultiBlockMaster master;
    private BlockEntity te;
    private MultiBlockGlueProvider iMultiBlockGlueProvider;

    public Glue(BlockEntity te, MultiBlockGlueProvider iMultiBlockGlueProvider) {
        this.te = te;
        this.iMultiBlockGlueProvider = iMultiBlockGlueProvider;
    }

    @Override
    public void clearMaster() {
        if (this.hasMaster()) {
            this.master = null;
            if (this.te.getLevel() != null) {
                this.te.getLevel().setBlock(this.te.getBlockPos(), (BlockState)this.te.getBlockState().cycle((Property)BlockStateProperties.ATTACHED), 3);
            }
            WorldHelper.updateClient(this.te.getLevel(), this.te.getBlockPos());
            WorldHelper.updateNeighbours(this.te.getLevel(), this.te.getBlockPos());
        }
    }

    @Override
    public void setMaster(MultiBlockMaster master) {
        if (master == null) {
            return;
        }
        if (this.master == null || !this.master.equals(master)) {
            this.master = master;
            this.te.getLevel().setBlock(this.te.getBlockPos(), (BlockState)this.te.getBlockState().setValue((Property)BlockStateProperties.ATTACHED, (Comparable)Boolean.valueOf(true)), 3);
            WorldHelper.updateClient(this.te.getLevel(), this.te.getBlockPos());
            WorldHelper.updateNeighbours(this.te.getLevel(), this.te.getBlockPos());
        }
    }

    @Override
    public void onGoodbye() {
        if (this.hasMaster()) {
            this.master.interrupt();
        }
    }

    @Override
    public void onHello(Level world, BlockPos pos) {
        MultiBlockMaster tmpMaster;
        if (!this.hasMaster() && (tmpMaster = GlueHelper.findMaster(world, this.iMultiBlockGlueProvider)) != null) {
            tmpMaster.interrupt();
        }
    }

    @Override
    public boolean hasMaster() {
        return this.master != null;
    }

    @Override
    public BlockPos getPos() {
        return this.te.getBlockPos();
    }
}

