/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.factory.multiblock;

import ipsis.woot.modules.factory.blocks.HeartBlock;
import ipsis.woot.modules.factory.multiblock.MultiBlockGlueProvider;
import ipsis.woot.modules.factory.multiblock.MultiBlockMaster;
import java.util.ArrayList;
import java.util.Stack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class GlueHelper {
    private static boolean isGlueBlock(Block b) {
        return b instanceof MultiBlockGlueProvider;
    }

    private static boolean isMaster(Block b) {
        return b instanceof HeartBlock;
    }

    public static MultiBlockMaster findMasterNoTE(Level world, BlockPos origin) {
        ArrayList<BlockPos> connected = new ArrayList<BlockPos>();
        Stack<BlockPos> traversing = new Stack<BlockPos>();
        MultiBlockMaster master = null;
        traversing.add(origin);
        while (master == null && !traversing.isEmpty()) {
            BlockPos currPos = (BlockPos)traversing.pop();
            connected.add(currPos);
            for (Direction facing : Direction.values()) {
                BlockEntity te;
                BlockPos pos = currPos.offset(facing.getNormal());
                if (!world.isLoaded(pos)) continue;
                Block b = world.getBlockState(pos).getBlock();
                if (GlueHelper.isGlueBlock(b) && !connected.contains(pos)) {
                    traversing.add(pos);
                    continue;
                }
                if (!GlueHelper.isMaster(b) || !((te = world.getBlockEntity(pos)) instanceof MultiBlockMaster)) continue;
                master = (MultiBlockMaster)te;
            }
        }
        return master;
    }

    public static MultiBlockMaster findMaster(Level world, MultiBlockGlueProvider iMultiBlockGlueProvider) {
        ArrayList<MultiBlockGlueProvider> connected = new ArrayList<MultiBlockGlueProvider>();
        Stack<MultiBlockGlueProvider> traversing = new Stack<MultiBlockGlueProvider>();
        MultiBlockMaster master = null;
        traversing.add(iMultiBlockGlueProvider);
        while (master == null && !traversing.isEmpty()) {
            MultiBlockGlueProvider curr = (MultiBlockGlueProvider)traversing.pop();
            connected.add(curr);
            for (Direction facing : Direction.values()) {
                BlockPos pos = curr.getGlue().getPos().offset(facing.getNormal());
                if (!world.isLoaded(pos)) continue;
                BlockEntity te = world.getBlockEntity(curr.getGlue().getPos().offset(facing.getNormal()));
                if (te instanceof MultiBlockGlueProvider && !connected.contains(te)) {
                    traversing.add((MultiBlockGlueProvider)te);
                    continue;
                }
                if (!(te instanceof MultiBlockMaster)) continue;
                master = (MultiBlockMaster)te;
            }
        }
        return master;
    }
}

