/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.factory.multiblock;

import ipsis.woot.modules.factory.FactorySetup;
import ipsis.woot.modules.factory.multiblock.Glue;
import ipsis.woot.modules.factory.multiblock.MultiBlockGlue;
import ipsis.woot.modules.factory.multiblock.MultiBlockGlueProvider;
import ipsis.woot.modules.factory.multiblock.MultiBlockTracker;
import ipsis.woot.util.WootDebug;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MultiBlockBlockEntity
extends BlockEntity
implements MultiBlockGlueProvider,
WootDebug {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String REGNAME = "multiblock";
    protected MultiBlockGlue glue = new Glue(this, this);

    public MultiBlockBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public MultiBlockBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FactorySetup.MULTIBLOCK_BLOCK_TILE.get(), pos, state);
    }

    public void clearRemoved() {
        super.clearRemoved();
        if (!this.level.isClientSide) {
            MultiBlockTracker.get().addEntry(this.level, this.getBlockPos());
        }
    }

    public void setRemoved() {
        super.setRemoved();
        if (!this.level.isClientSide) {
            this.glue.onGoodbye();
        }
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        if (!this.level.isClientSide) {
            this.glue.onGoodbye();
        }
    }

    @Override
    @Nonnull
    public MultiBlockGlue getGlue() {
        return this.glue;
    }

    @Override
    public List<String> getDebugText(List<String> debug, UseOnContext itemUseContext) {
        return List.of();
    }
}

