/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.factory.multiblock;

import com.google.common.collect.Lists;
import ipsis.woot.modules.factory.multiblock.MultiBlockGlueProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MultiBlockTracker {
    private static final Logger LOGGER = LogManager.getLogger();
    static MultiBlockTracker INSTANCE = new MultiBlockTracker();
    private List<MultiBlock> syncBlocks = new ArrayList<MultiBlock>();

    public static MultiBlockTracker get() {
        return INSTANCE;
    }

    public void addEntry(Level world, BlockPos pos) {
        this.syncBlocks.add(new MultiBlock(pos, world));
    }

    public void run(Level world) {
        if (world.isClientSide) {
            return;
        }
        ArrayList helloBlocks = Lists.newArrayList();
        Iterator<MultiBlock> i = this.syncBlocks.iterator();
        while (i.hasNext()) {
            MultiBlock m = i.next();
            if (m.world != world) continue;
            helloBlocks.add(m);
            i.remove();
        }
        if (helloBlocks.isEmpty()) {
            return;
        }
        for (MultiBlock m : helloBlocks) {
            BlockEntity te;
            if (!world.isLoaded(m.pos) || !((te = world.getBlockEntity(m.pos)) instanceof MultiBlockGlueProvider)) continue;
            ((MultiBlockGlueProvider)te).getGlue().onHello(world, te.getBlockPos());
        }
    }

    private static class MultiBlock {
        BlockPos pos;
        Level world;

        public MultiBlock(BlockPos pos, Level world) {
            this.world = world;
            this.pos = new BlockPos((Vec3i)pos);
        }
    }
}

