/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.factory.network;

import ipsis.woot.modules.factory.FormedSetup;
import ipsis.woot.modules.factory.blocks.HeartMenu;
import ipsis.woot.modules.factory.blocks.HeartRecipe;
import ipsis.woot.modules.factory.client.ClientFactorySetup;
import ipsis.woot.modules.factory.perks.Helper;
import ipsis.woot.simulator.MobSimulator;
import ipsis.woot.util.FakeMob;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record HeartStaticDataReply(FormedSetup formedSetup, HeartRecipe recipe, ClientFactorySetup clientSetup) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<HeartStaticDataReply> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"woot", (String)"heartstaticreply"));
    public static final StreamCodec<RegistryFriendlyByteBuf, HeartStaticDataReply> STREAM_CODEC = StreamCodec.of((buf, reply) -> ClientFactorySetup.STREAM_CODEC.encode(buf, (Object)reply.clientSetup), buf -> new HeartStaticDataReply(null, null, (ClientFactorySetup)ClientFactorySetup.STREAM_CODEC.decode(buf)));

    public HeartStaticDataReply(FormedSetup formedSetup, HeartRecipe recipe) {
        this(formedSetup, recipe, new ClientFactorySetup());
        this.populate(this.clientSetup, formedSetup, recipe);
    }

    public void populate(ClientFactorySetup setup, FormedSetup formedSetup, HeartRecipe recipe) {
        setup.tier = formedSetup.getTier();
        setup.controllerMobs = formedSetup.getAllMobs();
        formedSetup.getAllPerks().keySet().forEach(group -> setup.perks.add(Helper.getPerk(group, this.formedSetup().getAllPerks().get(group))));
        setup.mobParams.putAll(formedSetup.getAllMobParams());
        setup.exotic = formedSetup.getExotic();
        setup.cellCapacity = formedSetup.getCellCapacity();
        setup.looting = formedSetup.getLootingLevel();
        setup.recipeTicks = recipe.numTicks();
        setup.recipeFluid = recipe.numUnits();
        setup.perkCapped = formedSetup.isPerkCapped();
        setup.shardDropChance = this.formedSetup().getShardDropChance();
        setup.shardDrops = new double[]{formedSetup.getBasicShardWeight(), formedSetup.getAdvancedShardWeight(), formedSetup.getEliteShardWeight()};
        setup.controllerMobs.forEach(mob -> setup.mobInfo.put((FakeMob)mob, new ClientFactorySetup.Mob(MobSimulator.getInstance().getDropSummary((FakeMob)mob))));
        setup.itemIng = recipe.recipeItems();
        setup.fluidIng = recipe.recipeFluids();
    }

    public static void handle(HeartStaticDataReply reply, IPayloadContext ctx) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player.containerMenu instanceof HeartMenu) {
            ((HeartMenu)player.containerMenu).handleStaticDataReply(reply.clientSetup);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

