/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.factory.perks;

import ipsis.woot.util.ExtraWootCodecs;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;

public enum Perk implements StringRepresentable
{
    empty(null),
    efficiency_1(Group.efficiency),
    efficiency_2(Group.efficiency),
    efficiency_3(Group.efficiency),
    looting_1(Group.looting),
    looting_2(Group.looting),
    looting_3(Group.looting),
    mass_1(Group.mass),
    mass_2(Group.mass),
    mass_3(Group.mass),
    rate_1(Group.rate),
    rate_2(Group.rate),
    rate_3(Group.rate),
    tier_shard_1(Group.tier_shard),
    tier_shard_2(Group.tier_shard),
    tier_shard_3(Group.tier_shard),
    xp_1(Group.xp),
    xp_2(Group.xp),
    xp_3(Group.xp),
    headless_1(Group.headless),
    headless_2(Group.headless),
    headless_3(Group.headless),
    slaughter_1(Group.slaughter),
    slaughter_2(Group.slaughter),
    slaughter_3(Group.slaughter),
    crusher_1(Group.crusher),
    crusher_2(Group.crusher),
    crusher_3(Group.crusher),
    laser_1(Group.laser),
    laser_2(Group.laser),
    laser_3(Group.laser),
    flayed_1(Group.flayed),
    flayed_2(Group.flayed),
    flayed_3(Group.flayed);

    private Group group;
    public static Perk[] VALUES;
    public static final EnumSet<Perk> LEVEL_1_PERKS;
    public static final EnumSet<Perk> LEVEL_2_PERKS;
    public static final EnumSet<Perk> LEVEL_3_PERKS;
    public static final EnumSet<Perk> EFFICIENCY_PERKS;
    public static final EnumSet<Perk> LOOTING_PERKS;
    public static final EnumSet<Perk> MASS_PERKS;
    public static final EnumSet<Perk> RATE_PERKS;
    public static final EnumSet<Perk> XP_PERKS;
    public static final EnumSet<Perk> TIER_SHARD_PERKS;
    public static final EnumSet<Perk> HEADLESS_PERKS;
    public static final EnumSet<Perk> SLAUGHTER_PERKS;
    public static final EnumSet<Perk> CRUSHER_PERKS;
    public static final EnumSet<Perk> LASER_PERKS;
    public static final EnumSet<Perk> FLAYED_PERKS;
    private static final Map<Group, EnumSet<Perk>> perkMap;
    public static final StreamCodec<RegistryFriendlyByteBuf, Perk> STREAM_CODEC;

    private Perk(Group group) {
        this.group = group;
    }

    public String getLowerCaseName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public String getString() {
        return this.getLowerCaseName();
    }

    public static Perk byIndex(int index) {
        index = Math.clamp((long)index, 0, VALUES.length - 1);
        return VALUES[index];
    }

    public static EnumSet<Perk> getPerksByGroup(Group group) {
        EnumSet<Perk> perks = perkMap.get((Object)group);
        if (perks == null) {
            throw new IllegalArgumentException("No map entry for perk group");
        }
        return perkMap.get((Object)group);
    }

    public static Group getGroup(Perk perk) {
        return perk.group;
    }

    public static int getLevel(Perk perk) {
        int level = 3;
        if (LEVEL_1_PERKS.contains((Object)perk)) {
            level = 1;
        } else if (LEVEL_2_PERKS.contains((Object)perk)) {
            level = 2;
        }
        return level;
    }

    public String getSerializedName() {
        return this.name();
    }

    static {
        VALUES = Perk.values();
        LEVEL_1_PERKS = EnumSet.of(efficiency_1, new Perk[]{looting_1, mass_1, rate_1, tier_shard_1, xp_1, headless_1, slaughter_1, crusher_1, laser_1, flayed_1});
        LEVEL_2_PERKS = EnumSet.of(efficiency_2, new Perk[]{looting_2, mass_2, rate_2, tier_shard_2, xp_2, headless_2, slaughter_2, crusher_2, laser_2, flayed_2});
        LEVEL_3_PERKS = EnumSet.of(efficiency_3, new Perk[]{looting_3, mass_3, rate_3, tier_shard_3, xp_3, headless_3, slaughter_3, crusher_3, laser_3, flayed_3});
        EFFICIENCY_PERKS = EnumSet.of(efficiency_1, efficiency_2, efficiency_3);
        LOOTING_PERKS = EnumSet.of(looting_1, looting_2, looting_3);
        MASS_PERKS = EnumSet.of(mass_1, mass_2, mass_3);
        RATE_PERKS = EnumSet.of(rate_1, rate_2, rate_3);
        XP_PERKS = EnumSet.of(xp_1, xp_2, xp_3);
        TIER_SHARD_PERKS = EnumSet.of(tier_shard_1, tier_shard_2, tier_shard_3);
        HEADLESS_PERKS = EnumSet.of(headless_1, headless_2, headless_3);
        SLAUGHTER_PERKS = EnumSet.of(slaughter_1, slaughter_2, slaughter_3);
        CRUSHER_PERKS = EnumSet.of(crusher_1, crusher_2, crusher_3);
        LASER_PERKS = EnumSet.of(laser_1, laser_2, laser_3);
        FLAYED_PERKS = EnumSet.of(flayed_1, flayed_2, flayed_3);
        perkMap = new HashMap<Group, EnumSet<Perk>>();
        perkMap.put(Group.efficiency, EFFICIENCY_PERKS);
        perkMap.put(Group.looting, LOOTING_PERKS);
        perkMap.put(Group.mass, MASS_PERKS);
        perkMap.put(Group.rate, RATE_PERKS);
        perkMap.put(Group.xp, XP_PERKS);
        perkMap.put(Group.tier_shard, TIER_SHARD_PERKS);
        perkMap.put(Group.headless, HEADLESS_PERKS);
        perkMap.put(Group.slaughter, SLAUGHTER_PERKS);
        perkMap.put(Group.crusher, CRUSHER_PERKS);
        perkMap.put(Group.laser, LASER_PERKS);
        perkMap.put(Group.flayed, FLAYED_PERKS);
        STREAM_CODEC = ExtraWootCodecs.enumStreamCodec(Perk.class);
    }

    public static enum Group {
        efficiency,
        looting,
        mass,
        rate,
        xp,
        tier_shard,
        headless,
        slaughter,
        crusher,
        laser,
        flayed;

        private static final Group[] VALUES;
        public static final StreamCodec<RegistryFriendlyByteBuf, Group> STREAM_CODEC;

        public static Group byIndex(int index) {
            index = Math.clamp((long)index, 0, VALUES.length - 1);
            return VALUES[index];
        }

        public String getLowerCaseName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            VALUES = Group.values();
            STREAM_CODEC = ExtraWootCodecs.enumStreamCodec(Group.class);
        }
    }
}

