/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.fluidconvertor.blocks;

import ipsis.woot.crafting.WootRecipes;
import ipsis.woot.crafting.fluidconvertor.ConvertorRecipeInput;
import ipsis.woot.crafting.fluidconvertor.FluidConvertorRecipe;
import ipsis.woot.modules.fluidconvertor.FluidConvertorConfiguration;
import ipsis.woot.modules.fluidconvertor.FluidConvertorSetup;
import ipsis.woot.modules.fluidconvertor.blocks.FluidConvertorMenu;
import ipsis.woot.util.WootDebug;
import ipsis.woot.util.WootMachineBlockEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class FluidConvertorBlockEntity
extends WootMachineBlockEntity
implements WootDebug,
MenuProvider {
    static final int INPUT_SLOT = 0;
    private boolean firstTick = true;
    private FluidConvertorRecipe currRecipe = null;

    public FluidConvertorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FluidConvertorSetup.FLUID_CONVERTOR_BLOCK_TILE.get(), pos, state);
        this.stackInputHandler = new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                FluidConvertorBlockEntity.this.onContentsChanged(slot);
                FluidConvertorBlockEntity.this.setChanged();
            }

            public boolean isItemValidForSlot(int slot, @Nonnull ItemStack stack) {
                if (slot == 0) {
                    return FluidConvertorRecipe.isValidCatalyst(stack);
                }
                return false;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValidForSlot(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    public void configureSides() {
        Direction direction = (Direction)this.level.getBlockState(this.getBlockPos()).getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        if (direction == Direction.NORTH) {
            this.settings.put(Direction.UP, WootMachineBlockEntity.Mode.INPUT);
            this.settings.put(Direction.DOWN, WootMachineBlockEntity.Mode.OUTPUT);
            this.settings.put(Direction.WEST, WootMachineBlockEntity.Mode.OUTPUT);
            this.settings.put(Direction.SOUTH, WootMachineBlockEntity.Mode.OUTPUT);
            this.settings.put(Direction.EAST, WootMachineBlockEntity.Mode.INPUT);
            this.settings.put(Direction.NORTH, WootMachineBlockEntity.Mode.INPUT);
        } else if (direction == Direction.SOUTH) {
            this.settings.put(Direction.UP, WootMachineBlockEntity.Mode.INPUT);
            this.settings.put(Direction.DOWN, WootMachineBlockEntity.Mode.OUTPUT);
            this.settings.put(Direction.WEST, WootMachineBlockEntity.Mode.INPUT);
            this.settings.put(Direction.SOUTH, WootMachineBlockEntity.Mode.INPUT);
            this.settings.put(Direction.EAST, WootMachineBlockEntity.Mode.OUTPUT);
            this.settings.put(Direction.NORTH, WootMachineBlockEntity.Mode.OUTPUT);
        } else if (direction == Direction.WEST) {
            this.settings.put(Direction.UP, WootMachineBlockEntity.Mode.INPUT);
            this.settings.put(Direction.DOWN, WootMachineBlockEntity.Mode.OUTPUT);
            this.settings.put(Direction.WEST, WootMachineBlockEntity.Mode.INPUT);
            this.settings.put(Direction.SOUTH, WootMachineBlockEntity.Mode.OUTPUT);
            this.settings.put(Direction.EAST, WootMachineBlockEntity.Mode.OUTPUT);
            this.settings.put(Direction.NORTH, WootMachineBlockEntity.Mode.INPUT);
        } else if (direction == Direction.EAST) {
            this.settings.put(Direction.UP, WootMachineBlockEntity.Mode.INPUT);
            this.settings.put(Direction.DOWN, WootMachineBlockEntity.Mode.OUTPUT);
            this.settings.put(Direction.WEST, WootMachineBlockEntity.Mode.OUTPUT);
            this.settings.put(Direction.SOUTH, WootMachineBlockEntity.Mode.INPUT);
            this.settings.put(Direction.EAST, WootMachineBlockEntity.Mode.INPUT);
            this.settings.put(Direction.NORTH, WootMachineBlockEntity.Mode.OUTPUT);
        }
    }

    @Override
    public void tick(Level level) {
        if (this.firstTick && level != null) {
            this.configureSides();
            this.firstTick = false;
        }
        super.tick(level);
        if (!level.isClientSide) {
            return;
        }
        if (this.fluidOutputHandler.isEmpty()) {
            return;
        }
        for (Direction direction : Direction.values()) {
            Optional<IFluidHandler> lazyOptional;
            BlockEntity te;
            if (this.settings.get(direction) != WootMachineBlockEntity.Mode.OUTPUT || (te = level.getBlockEntity(this.getBlockPos().offset(direction.getNormal()))) == null || !(lazyOptional = Optional.ofNullable((IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, te.getBlockPos(), (Object)direction.getOpposite()))).isPresent()) continue;
            IFluidHandler iFluidHandler = lazyOptional.orElseThrow(NullPointerException::new);
            FluidStack fluidStack = this.fluidOutputHandler.getFluid();
            if (fluidStack.isEmpty()) continue;
            int filled = iFluidHandler.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
            this.fluidOutputHandler.drain(filled, IFluidHandler.FluidAction.EXECUTE);
            this.setChanged();
        }
    }

    public FluidStack getInputTankFluid() {
        return this.fluidInputHandler.getFluid();
    }

    public FluidStack getOutputTankFluid() {
        return this.fluidOutputHandler.getFluid();
    }

    public int getEnergy() {
        return this.energyStorage.getEnergyStored();
    }

    @Override
    public List<String> getDebugText(List<String> debug, UseOnContext itemUseContext) {
        debug.add("====> " + this.getClass().toString());
        debug.add("      Input Tank " + this.getInputTankFluid().getDescriptionId() + " " + this.getInputTankFluid().getAmount());
        debug.add("      Output Tank " + this.getOutputTankFluid().getDescriptionId() + " " + this.getOutputTankFluid().getAmount());
        debug.add("      Energy " + this.getEnergy());
        if (this.currRecipe != null) {
            debug.add("      Energy " + String.valueOf(this.currRecipe));
        }
        debug.add("      Settings " + String.valueOf(this.settings));
        return debug;
    }

    public Component getDisplayName() {
        return Component.translatable((String)"gui.woot.fluidconvertor.name");
    }

    public int getProgress() {
        return this.calculateProgress();
    }

    @Override
    protected boolean hasEnergy() {
        return this.energyStorage.getEnergyStored() > 0;
    }

    @Override
    protected int useEnergy() {
        return this.energyStorage.extractEnergy(((Integer)FluidConvertorConfiguration.FLUID_CONV_ENERYG_PER_TICK.get()).intValue(), false);
    }

    @Override
    protected void clearRecipe() {
        this.currRecipe = null;
    }

    @Override
    protected int getRecipeEnergy() {
        return this.currRecipe != null ? this.currRecipe.getEnergy() : 0;
    }

    @Override
    protected void processFinish() {
        if (this.currRecipe == null) {
            this.getRecipe();
        }
        if (this.currRecipe == null) {
            this.processOff();
            return;
        }
        FluidConvertorRecipe finishedRecipe = this.currRecipe;
        this.stackInputHandler.extractItem(0, finishedRecipe.getCatalystCount(), false);
        this.fluidInputHandler.drain(finishedRecipe.getInputFluid().getAmount(), IFluidHandler.FluidAction.EXECUTE);
        this.fluidOutputHandler.fill(finishedRecipe.getOutput().copy(), IFluidHandler.FluidAction.EXECUTE);
        this.setChanged();
    }

    @Override
    protected boolean canStart() {
        int filled;
        if (this.energyStorage.getEnergyStored() <= 0) {
            return false;
        }
        if (this.fluidInputHandler.isEmpty()) {
            return false;
        }
        this.getRecipe();
        if (this.currRecipe == null) {
            return false;
        }
        if (this.stackInputHandler.getStackInSlot(0).getCount() < this.currRecipe.getCatalystCount()) {
            return false;
        }
        FluidStack inFluid = this.fluidInputHandler.getFluid();
        if (inFluid.isEmpty()) {
            return false;
        }
        if (inFluid.getAmount() < this.currRecipe.getInputFluid().getAmount()) {
            return false;
        }
        int amount = this.currRecipe.getOutput().getAmount();
        return amount == (filled = this.fluidOutputHandler.fill(new FluidStack(this.currRecipe.outputFluid().getFluidHolder(), amount), IFluidHandler.FluidAction.SIMULATE));
    }

    @Override
    protected boolean hasValidInput() {
        if (this.currRecipe == null) {
            this.getRecipe();
        }
        if (this.currRecipe == null) {
            return false;
        }
        if (this.stackInputHandler.getStackInSlot(0).getCount() < this.currRecipe.getCatalystCount()) {
            return false;
        }
        FluidStack inFluid = this.fluidInputHandler.getFluid();
        if (inFluid.isEmpty()) {
            return false;
        }
        return inFluid.getAmount() >= this.currRecipe.getInputFluid().getAmount();
    }

    @Override
    protected boolean isDisabled() {
        return false;
    }

    private void getRecipe() {
        this.clearRecipe();
        FluidStack inFluid = this.fluidInputHandler.getFluid();
        if (inFluid.isEmpty()) {
            return;
        }
        ItemStack catalyst = this.stackInputHandler.getStackInSlot(0);
        if (catalyst.isEmpty()) {
            return;
        }
        Optional recipe = this.level.getRecipeManager().getRecipeFor((RecipeType)WootRecipes.FLUID_CONVERTOR_TYPE.get(), (RecipeInput)new ConvertorRecipeInput(catalyst, inFluid), this.level);
        this.currRecipe = recipe.map(RecipeHolder::value).orElse(null);
    }

    public void dropContents(Level world, BlockPos pos) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        ItemStack itemStack = this.stackInputHandler.getStackInSlot(0);
        if (!itemStack.isEmpty()) {
            drops.add(itemStack);
            this.stackInputHandler.insertItem(0, ItemStack.EMPTY, false);
        }
        super.dropContents(drops);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new FluidConvertorMenu(i, inventory, this);
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)FluidConvertorSetup.FLUID_CONVERTOR_BLOCK_TILE.get(), (be, direction) -> be.energyStorage);
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)FluidConvertorSetup.FLUID_CONVERTOR_BLOCK_TILE.get(), (be, direction) -> {
            if (direction == null || direction == ((Direction)be.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getClockWise() || direction == Direction.DOWN) {
                return be.fluidOutputHandler;
            }
            return be.fluidInputHandler;
        });
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)FluidConvertorSetup.FLUID_CONVERTOR_BLOCK_TILE.get(), (be, direction) -> be.stackInputHandler);
    }
}

