/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.fluidconvertor.blocks;

import ipsis.woot.crafting.fluidconvertor.FluidConvertorRecipe;
import ipsis.woot.fluilds.network.TankPacket;
import ipsis.woot.modules.fluidconvertor.FluidConvertorSetup;
import ipsis.woot.modules.fluidconvertor.blocks.FluidConvertorBlockEntity;
import ipsis.woot.util.TankPacketHandler;
import ipsis.woot.util.WootContainer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.neoforged.neoforge.network.PacketDistributor;

public class FluidConvertorMenu
extends WootContainer
implements TankPacketHandler {
    public FluidConvertorBlockEntity tileEntity;
    Player player;
    private FluidStack inputFluid = FluidStack.EMPTY;
    private FluidStack outputFluid = FluidStack.EMPTY;
    private int progress = 0;
    private int energy = 0;

    public FluidConvertorMenu(int containerId, Inventory inv, FriendlyByteBuf extraData) {
        this(containerId, inv, inv.player.level().getBlockEntity(extraData.readBlockPos()));
    }

    public FluidConvertorMenu(int windowId, Inventory playerInventory, BlockEntity entity) {
        super((MenuType)FluidConvertorSetup.FLUID_CONVERTOR_BLOCK_CONTATAINER.get(), windowId);
        this.tileEntity = (FluidConvertorBlockEntity)entity;
        this.player = playerInventory.player;
        this.addOwnSlots(this.tileEntity.stackInputHandler);
        this.addPlayerSlots(playerInventory);
        this.addListeners();
    }

    private void addOwnSlots(ItemStackHandler inv) {
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)inv, 0, 100, 22));
    }

    private void addPlayerSlots(Inventory playerInventory) {
        int row;
        for (row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                int x = 10 + col * 18;
                int y = row * 18 + 95;
                this.addSlot(new Slot((Container)playerInventory, col + row * 9 + 9, x, y));
            }
        }
        for (row = 0; row < 9; ++row) {
            int x = 10 + row * 18;
            this.addSlot(new Slot((Container)playerInventory, row, x, 153));
        }
    }

    @Override
    public boolean stillValid(Player playerIn) {
        return FluidConvertorMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)playerIn.level(), (BlockPos)this.tileEntity.getBlockPos()), (Player)playerIn, (Block)((Block)FluidConvertorSetup.FLUID_CONVERTOR_BLOCK.get()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getProgress() {
        return this.progress;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getEnergy() {
        return this.energy;
    }

    @OnlyIn(value=Dist.CLIENT)
    public FluidStack getInputFluid() {
        return this.inputFluid;
    }

    @OnlyIn(value=Dist.CLIENT)
    public FluidStack getOutputFluid() {
        return this.outputFluid;
    }

    public void addListeners() {
        this.addDataSlot(new DataSlot(){

            public int get() {
                return FluidConvertorMenu.this.tileEntity.getEnergy();
            }

            public void set(int i) {
                FluidConvertorMenu.this.energy = i;
            }
        });
        this.addDataSlot(new DataSlot(){

            public int get() {
                return FluidConvertorMenu.this.tileEntity.getProgress();
            }

            public void set(int i) {
                FluidConvertorMenu.this.progress = i;
            }
        });
    }

    public void broadcastChanges() {
        TankPacket tankPacket;
        super.broadcastChanges();
        if (!FluidStack.isSameFluidSameComponents((FluidStack)this.inputFluid, (FluidStack)this.tileEntity.getInputTankFluid()) || this.inputFluid.getAmount() != this.tileEntity.getInputTankFluid().getAmount()) {
            this.inputFluid = this.tileEntity.getInputTankFluid().copy();
            tankPacket = new TankPacket(this.inputFluid, 0);
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)this.player), (CustomPacketPayload)tankPacket, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        if (!FluidStack.isSameFluidSameComponents((FluidStack)this.outputFluid, (FluidStack)this.tileEntity.getOutputTankFluid()) || this.outputFluid.getAmount() != this.tileEntity.getOutputTankFluid().getAmount()) {
            this.outputFluid = this.tileEntity.getOutputTankFluid().copy();
            tankPacket = new TankPacket(this.outputFluid, 1);
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)this.player), (CustomPacketPayload)tankPacket, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ItemStack quickMoveStack(Player playerIn, int index) {
        int endIndex;
        int startIndex;
        Slot slot = (Slot)this.slots.get(index);
        if (slot == null || !slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = slot.getItem();
        ItemStack stackCopy = stack.copy();
        boolean MACHINE_INV_SIZE = true;
        int PLAYER_INV_SIZE = 27;
        int TOOLBAR_INV_SIZE = 9;
        if (index >= 1) {
            if (FluidConvertorRecipe.isValidCatalyst(stack)) {
                startIndex = 0;
                endIndex = 1;
            } else if (index < 28) {
                startIndex = 28;
                endIndex = startIndex + 9;
            } else {
                if (index < 28) return ItemStack.EMPTY;
                startIndex = 1;
                endIndex = startIndex + 27;
            }
        } else {
            startIndex = 1;
            endIndex = startIndex + 27 + 9;
        }
        if (!this.moveItemStackTo(stack, startIndex, endIndex, false)) {
            return ItemStack.EMPTY;
        }
        if (stack.getCount() == 0) {
            slot.set(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        if (stack.getCount() == stackCopy.getCount()) {
            return ItemStack.EMPTY;
        }
        slot.onTake(playerIn, stack);
        return stackCopy;
    }

    @Override
    public void handlePacket(TankPacket packet) {
        if (packet.tankId() == 0) {
            this.inputFluid = packet.fluidStack();
        } else if (packet.tankId() == 1) {
            this.outputFluid = packet.fluidStack();
        }
    }
}

